/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.Attribute;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class ServerGroupDeploymentElement
extends AbstractModelElement<ServerGroupDeploymentElement> {
    private static final long serialVersionUID = -7282640684801436543L;
    private final String uniqueName;
    private final String runtimeName;
    private final byte[] sha1Hash;
    private boolean start;

    public ServerGroupDeploymentElement(String uniqueName, String runtimeName, byte[] sha1Hash, boolean start) {
        if (uniqueName == null) {
            throw new IllegalArgumentException("uniqueName is null");
        }
        if (runtimeName == null) {
            throw new IllegalArgumentException("runtimeName is null");
        }
        if (sha1Hash.length != 20) {
            throw new IllegalArgumentException("sha1Hash is not a valid length");
        }
        this.uniqueName = uniqueName;
        this.runtimeName = runtimeName;
        this.sha1Hash = sha1Hash;
        this.start = start;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public byte[] getSha1Hash() {
        byte[] copy = new byte[this.sha1Hash.length];
        System.arraycopy(this.sha1Hash, 0, copy, 0, this.sha1Hash.length);
        return copy;
    }

    public String getSha1HashAsHexString() {
        return ServerGroupDeploymentElement.bytesToHexString(this.sha1Hash);
    }

    public boolean isStart() {
        return this.start;
    }

    void setStart(boolean start) {
        this.start = start;
    }

    @Override
    protected Class<ServerGroupDeploymentElement> getElementClass() {
        return ServerGroupDeploymentElement.class;
    }

    @Override
    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.uniqueName);
        streamWriter.writeAttribute(Attribute.RUNTIME_NAME.getLocalName(), this.runtimeName);
        streamWriter.writeAttribute(Attribute.SHA1.getLocalName(), this.getSha1HashAsHexString());
        if (!this.start) {
            streamWriter.writeAttribute(Attribute.START.getLocalName(), "false");
        }
        streamWriter.writeEndElement();
    }
}

