/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractModelUpdate;
import org.jboss.as.model.ServerGroupDeploymentRemove;
import org.jboss.as.model.ServerGroupElement;
import org.jboss.as.model.ServerModelDeploymentAdd;
import org.jboss.as.model.UpdateFailedException;

public class ServerGroupDeploymentAdd
extends AbstractModelUpdate<ServerGroupElement, Void> {
    private static final long serialVersionUID = 5773083013951607950L;
    private final String uniqueName;
    private final String runtimeName;
    private final byte[] hash;
    private final boolean start;

    public ServerGroupDeploymentAdd(String uniqueName, String runtimeName, byte[] hash, boolean start) {
        if (uniqueName == null) {
            throw new IllegalArgumentException("uniqueName is null");
        }
        if (runtimeName == null) {
            throw new IllegalArgumentException("runtimeName is null");
        }
        if (hash == null) {
            throw new IllegalArgumentException("hash is null");
        }
        this.uniqueName = uniqueName;
        this.runtimeName = runtimeName;
        this.hash = hash;
        this.start = start;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public boolean isStart() {
        return this.start;
    }

    public ServerGroupDeploymentRemove getCompensatingUpdate(ServerGroupElement original) {
        return new ServerGroupDeploymentRemove(this.uniqueName);
    }

    protected ServerModelDeploymentAdd getServerModelUpdate() {
        return new ServerModelDeploymentAdd(this.uniqueName, this.runtimeName, this.hash);
    }

    @Override
    protected void applyUpdate(ServerGroupElement element) throws UpdateFailedException {
        if (element.getDeployment(this.uniqueName) != null) {
            throw new UpdateFailedException("Deployment " + this.uniqueName + " already added");
        }
        element.addDeployment(this.uniqueName, this.runtimeName, this.hash, this.start);
    }

    @Override
    public Class<ServerGroupElement> getModelElementType() {
        return ServerGroupElement.class;
    }
}

