/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.PathElement;
import org.jboss.as.model.PathElementUpdate;
import org.jboss.as.model.ServerElement;
import org.jboss.as.model.ServerElementPathAdd;
import org.jboss.as.model.ServerPathRemove;
import org.jboss.as.model.UpdateFailedException;

public class ServerElementPathRemove
extends AbstractModelUpdate<ServerElement, Void> {
    private static final long serialVersionUID = 5430076882310590299L;
    private final String name;

    public ServerElementPathRemove(String name) {
        this.name = name;
    }

    @Override
    public Class<ServerElement> getModelElementType() {
        return ServerElement.class;
    }

    @Override
    protected void applyUpdate(ServerElement element) throws UpdateFailedException {
        if (!element.removeInterface(this.name)) {
            throw new UpdateFailedException(String.format("path (%s) does not exist", this.name));
        }
    }

    public ServerElementPathAdd getCompensatingUpdate(ServerElement original) {
        PathElement path = original.getPath(this.name);
        if (path == null) {
            return null;
        }
        return new ServerElementPathAdd(new PathElementUpdate(this.name, path.getPath(), path.getRelativeTo()));
    }

    @Override
    protected AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return new ServerPathRemove(this.name);
    }
}

