/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.PathElement;
import org.jboss.as.model.PathElementUpdate;
import org.jboss.as.model.ServerElement;
import org.jboss.as.model.ServerElementPathRemove;
import org.jboss.as.model.ServerPathAdd;
import org.jboss.as.model.UpdateFailedException;

public class ServerElementPathAdd
extends AbstractModelUpdate<ServerElement, Void> {
    private static final long serialVersionUID = -24395835360343152L;
    private final PathElementUpdate update;

    public ServerElementPathAdd(PathElementUpdate update) {
        if (update == null) {
            throw new IllegalArgumentException("null path element update");
        }
        if (update.getPath() == null) {
            throw new IllegalArgumentException("null path for path element " + update.getName());
        }
        this.update = update;
    }

    @Override
    public Class<ServerElement> getModelElementType() {
        return ServerElement.class;
    }

    @Override
    protected void applyUpdate(ServerElement element) throws UpdateFailedException {
        PathElement path = element.addPath(this.update.getName());
        if (path == null) {
            throw new UpdateFailedException("duplicate path " + this.update.getName());
        }
        this.update.applyUpdate(path);
    }

    public ServerElementPathRemove getCompensatingUpdate(ServerElement original) {
        return new ServerElementPathRemove(this.update.getName());
    }

    @Override
    protected AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return new ServerPathAdd(this.update);
    }
}

