/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.ServerElement;
import org.jboss.as.model.ServerElementInterfaceAdd;
import org.jboss.as.model.ServerModelInterfaceRemove;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.socket.InterfaceAdd;
import org.jboss.as.model.socket.InterfaceElement;

public class ServerElementInterfaceRemove
extends AbstractModelUpdate<ServerElement, Void> {
    private static final long serialVersionUID = -2830177164001085749L;
    private final String interfaceName;

    public ServerElementInterfaceRemove(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    @Override
    protected void applyUpdate(ServerElement server) throws UpdateFailedException {
        if (!server.removeInterface(this.interfaceName)) {
            throw new UpdateFailedException();
        }
    }

    public ServerElementInterfaceAdd getCompensatingUpdate(ServerElement original) {
        InterfaceElement networkInterface = original.getInterface(this.interfaceName);
        if (networkInterface == null) {
            return null;
        }
        return new ServerElementInterfaceAdd(new InterfaceAdd(networkInterface));
    }

    @Override
    protected AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return new ServerModelInterfaceRemove(this.interfaceName);
    }

    @Override
    public Class<ServerElement> getModelElementType() {
        return ServerElement.class;
    }
}

