/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.io.Serializable;
import java.util.Map;

public final class Property
implements Comparable<Property>,
Serializable {
    private static final long serialVersionUID = 899626227115304356L;
    private final String name;
    private final String value;

    public Property(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
        this.value = value == null ? "" : value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        return other instanceof Property && this.equals((Property)other);
    }

    public boolean equals(Property other) {
        return this == other || other != null && other.name.equals(this.name) && other.value.equals(this.value);
    }

    public void addTo(Map<? super String, ? super String> map) {
        map.put(this.name, this.value);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    @Override
    public int compareTo(Property o) {
        int res = this.name.compareTo(o.name);
        return res == 0 ? this.value.compareTo(o.value) : res;
    }

    public String toString() {
        return "property " + this.name + "=" + this.value;
    }
}

