/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.Attribute;
import org.jboss.as.model.Element;
import org.jboss.as.model.Namespace;
import org.jboss.as.model.ParseUtils;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class PropertiesElement
extends AbstractModelElement<PropertiesElement> {
    private static final long serialVersionUID = 1614693052895734582L;
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private final Element propertyType;
    private final boolean allowNullValue;

    public PropertiesElement(Element propertyType, boolean allowNullValue) {
        this.propertyType = propertyType;
        this.allowNullValue = allowNullValue;
    }

    public PropertiesElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        this(reader, Element.PROPERTY, true);
    }

    public PropertiesElement(XMLExtendedStreamReader reader, Element propertyType, boolean allowNullValue) throws XMLStreamException {
        this.propertyType = propertyType;
        this.allowNullValue = allowNullValue;
        ParseUtils.requireNoAttributes(reader);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (element == propertyType) {
                        String name = null;
                        String value = null;
                        int count = reader.getAttributeCount();
                        block8: for (int i = 0; i < count; ++i) {
                            String attrValue = reader.getAttributeValue(i);
                            if (reader.getAttributeNamespace(i) != null) {
                                throw ParseUtils.unexpectedAttribute(reader, i);
                            }
                            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case NAME: {
                                    name = attrValue;
                                    if (!this.properties.containsKey(name)) continue block8;
                                    throw new XMLStreamException("Property " + name + " already exists", reader.getLocation());
                                }
                                case VALUE: {
                                    value = attrValue;
                                    continue block8;
                                }
                                default: {
                                    throw ParseUtils.unexpectedAttribute(reader, i);
                                }
                            }
                        }
                        if (name == null) {
                            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
                        }
                        if (value == null && !allowNullValue) {
                            throw new XMLStreamException("Value for property " + name + " is null", reader.getLocation());
                        }
                        this.properties.put(name, value);
                        ParseUtils.requireNoContent(reader);
                        continue block7;
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (this.properties.size() == 0) {
            throw ParseUtils.missingRequiredElement(reader, Collections.singleton(propertyType));
        }
    }

    public PropertiesElement(Element propertyType, boolean allowNullValue, PropertiesElement ... toCombine) {
        this.allowNullValue = allowNullValue;
        this.propertyType = propertyType;
        if (toCombine != null) {
            for (PropertiesElement pe : toCombine) {
                if (pe == null) continue;
                for (String name : pe.getPropertyNames()) {
                    String val = pe.getProperty(name);
                    if (!allowNullValue && val == null) {
                        throw new IllegalStateException("Property " + name + " has a null value");
                    }
                    this.properties.put(name, val);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long elementHash() {
        long total = 0L;
        Map<String, String> map = this.properties;
        synchronized (map) {
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                String val = entry.getValue();
                int valHash = val == null ? 0 : val.hashCode();
                total = Long.rotateLeft(total, 1) ^ ((long)entry.getKey().hashCode() << 32 | (long)valHash & 0xFFFFFFFFL);
            }
        }
        return total;
    }

    @Override
    protected Class<PropertiesElement> getElementClass() {
        return PropertiesElement.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        Map<String, String> map = this.properties;
        synchronized (map) {
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                streamWriter.writeEmptyElement(this.propertyType.getLocalName());
                streamWriter.writeAttribute(Attribute.NAME.getLocalName(), entry.getKey());
                if (this.allowNullValue && entry.getValue() == null) continue;
                streamWriter.writeAttribute(Attribute.VALUE.getLocalName(), entry.getValue());
            }
        }
        streamWriter.writeEndElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProperty(String name, String value) {
        Map<String, String> map = this.properties;
        synchronized (map) {
            if (this.properties.containsKey(name)) {
                throw new IllegalArgumentException("Property " + name + " already exists");
            }
            if (value == null && !this.allowNullValue) {
                throw new IllegalArgumentException("Value for property " + name + " is null");
            }
            this.properties.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String removeProperty(String name) {
        Map<String, String> map = this.properties;
        synchronized (map) {
            String old = this.properties.remove(name);
            if (old == null) {
                throw new IllegalArgumentException("Property " + name + " does not exist");
            }
            return old;
        }
    }

    public int size() {
        return this.properties.size();
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public Set<String> getPropertyNames() {
        return new HashSet<String>(this.properties.keySet());
    }

    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.properties);
    }
}

