/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.Attribute;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class ManagementElement
extends AbstractModelElement<ManagementElement> {
    private static final long serialVersionUID = 8470861221364095661L;
    private final String interfaceName;
    private final int port;
    private int maxThreads = 20;

    public ManagementElement(String interfaceName, int port) {
        this.interfaceName = interfaceName;
        this.port = port;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public int getPort() {
        return this.port;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    @Override
    protected Class<ManagementElement> getElementClass() {
        return ManagementElement.class;
    }

    @Override
    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute(Attribute.INTERFACE.getLocalName(), this.interfaceName);
        streamWriter.writeAttribute(Attribute.PORT.getLocalName(), Integer.toString(this.port));
        streamWriter.writeAttribute(Attribute.MAX_THREADS.getLocalName(), Integer.toString(this.maxThreads));
        streamWriter.writeEndElement();
    }

    void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }
}

