/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.Attribute;
import org.jboss.as.model.Element;
import org.jboss.as.model.JvmOptionsElement;
import org.jboss.as.model.JvmType;
import org.jboss.as.model.Namespace;
import org.jboss.as.model.ParseUtils;
import org.jboss.as.model.PropertiesElement;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JvmElement
extends AbstractModelElement<JvmElement> {
    private static final long serialVersionUID = 4963103173530602991L;
    private final String name;
    private JvmType type;
    private String javaHome;
    private Boolean debugEnabled;
    private String debugOptions;
    private Boolean envClasspathIgnored;
    private String heapSize;
    private String maxHeap;
    private String permgenSize;
    private String maxPermgen;
    private String agentPath;
    private String agentLib;
    private String javaagent;
    private String stack;
    private final JvmOptionsElement jvmOptionsElement = new JvmOptionsElement();
    private PropertiesElement environmentVariables = new PropertiesElement(Element.VARIABLE, true);
    private PropertiesElement systemProperties = new PropertiesElement(Element.PROPERTY, true);

    public JvmElement(String name) {
        this.name = name;
    }

    public JvmElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        String name = null;
        String type = null;
        String home = null;
        int count = reader.getAttributeCount();
        block23: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block23;
                }
                case TYPE: {
                    type = value;
                    try {
                        this.type = Enum.valueOf(JvmType.class, type.toUpperCase());
                        continue block23;
                    }
                    catch (Exception e) {
                        throw ParseUtils.invalidAttributeValue(reader, i);
                    }
                }
                case JAVA_HOME: {
                    home = value;
                    continue block23;
                }
                case DEBUG_ENABLED: {
                    this.debugEnabled = Boolean.valueOf(value);
                    continue block23;
                }
                case DEBUG_OPTIONS: {
                    this.debugOptions = value;
                    continue block23;
                }
                case ENV_CLASSPATH_IGNORED: {
                    this.envClasspathIgnored = Boolean.valueOf(value);
                    continue block23;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
        }
        this.name = name;
        this.javaHome = home;
        if (type == null) {
            this.type = JvmType.SUN;
        }
        block24: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case HEAP: {
                            if (this.heapSize != null || this.maxHeap != null) {
                                throw new XMLStreamException(element.getLocalName() + " already declared", reader.getLocation());
                            }
                            this.parseMinMax(reader, new HeapSetter());
                            continue block24;
                        }
                        case PERMGEN: {
                            if (this.permgenSize != null || this.maxPermgen != null) {
                                throw new XMLStreamException(element.getLocalName() + " already declared", reader.getLocation());
                            }
                            this.parseMinMax(reader, new PermGenSetter());
                            continue block24;
                        }
                        case STACK: {
                            if (this.stack != null) {
                                throw new XMLStreamException(element.getLocalName() + " already declared", reader.getLocation());
                            }
                            this.parseStack(reader);
                            continue block24;
                        }
                        case ENVIRONMENT_VARIABLES: {
                            if (this.environmentVariables != null) {
                                throw new XMLStreamException(element.getLocalName() + " already declared", reader.getLocation());
                            }
                            this.environmentVariables = new PropertiesElement(reader, Element.VARIABLE, true);
                            continue block24;
                        }
                        case SYSTEM_PROPERTIES: {
                            if (this.systemProperties != null) {
                                throw new XMLStreamException(element.getLocalName() + " already declared", reader.getLocation());
                            }
                            this.systemProperties = new PropertiesElement(reader);
                            continue block24;
                        }
                        case AGENT_LIB: {
                            if (this.agentLib != null) {
                                throw new XMLStreamException(element.getLocalName() + " already declared", reader.getLocation());
                            }
                            if (this.agentPath != null) {
                                throw new XMLStreamException(element.getLocalName() + " when we already also have a " + (Object)((Object)Element.AGENT_PATH), reader.getLocation());
                            }
                            this.agentLib = this.parseValue(reader);
                            continue block24;
                        }
                        case AGENT_PATH: {
                            if (this.agentPath != null) {
                                throw new XMLStreamException(element.getLocalName() + " already declared", reader.getLocation());
                            }
                            if (this.agentLib != null) {
                                throw new XMLStreamException(element.getLocalName() + " when we already also have a " + (Object)((Object)Element.AGENT_LIB), reader.getLocation());
                            }
                            this.agentPath = this.parseValue(reader);
                            continue block24;
                        }
                        case JAVA_AGENT: {
                            this.javaagent = this.parseValue(reader);
                            continue block24;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    public JvmElement(JvmElement ... toCombine) {
        this.name = toCombine[0].getName();
        for (JvmElement element : toCombine) {
            if (element == null) continue;
            if (!this.name.equals(element.getName())) {
                throw new IllegalArgumentException("Jvm " + element.getName() + " has a different name from the other jvm elements; all must have the same name");
            }
            if (element.getJavaHome() != null) {
                this.javaHome = element.getJavaHome();
            }
            if (element.getJvmType() != null) {
                this.type = element.getJvmType();
            }
            if (element.getDebugOptions() != null) {
                this.debugOptions = element.getDebugOptions();
            }
            if (element.isDebugEnabled() != null) {
                this.debugEnabled = element.isDebugEnabled();
            }
            if (element.isEnvClasspathIgnored() != null) {
                this.envClasspathIgnored = element.isEnvClasspathIgnored();
            }
            if (element.getPermgenSize() != null) {
                this.permgenSize = element.getPermgenSize();
            }
            if (element.getMaxPermgen() != null) {
                this.maxPermgen = element.getMaxPermgen();
            }
            if (element.getHeapSize() != null) {
                this.heapSize = element.getHeapSize();
            }
            if (element.getMaxHeap() != null) {
                this.maxHeap = element.getMaxHeap();
            }
            if (element.getStack() != null) {
                this.stack = element.getStack();
            }
            if (element.getAgentLib() != null) {
                this.agentLib = element.getAgentLib();
            }
            if (element.getAgentPath() != null) {
                this.agentPath = element.getAgentPath();
            }
            if (element.getJavaagent() == null) continue;
            this.javaagent = element.getJavaagent();
        }
        PropertiesElement[] combinedEnv = new PropertiesElement[toCombine.length];
        for (int i = 0; i < toCombine.length; ++i) {
            if (toCombine[i] == null) continue;
            combinedEnv[i] = toCombine[i].getEnvironmentVariables();
        }
        this.environmentVariables = new PropertiesElement(Element.ENVIRONMENT_VARIABLES, true, combinedEnv);
        PropertiesElement[] combinedSysp = new PropertiesElement[toCombine.length];
        for (int i = 0; i < toCombine.length; ++i) {
            if (toCombine[i] == null) continue;
            combinedSysp[i] = toCombine[i].getSystemProperties();
        }
        this.systemProperties = new PropertiesElement(Element.SYSTEM_PROPERTIES, true, combinedSysp);
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public JvmType getJvmType() {
        return this.type;
    }

    void setJvmType(JvmType type) {
        this.type = type;
    }

    public String getPermgenSize() {
        return this.permgenSize;
    }

    void setPermgenSize(String permgenSize) {
        this.permgenSize = permgenSize;
    }

    public String getMaxPermgen() {
        return this.maxPermgen;
    }

    void setMaxPermgen(String maxPermgen) {
        this.maxPermgen = maxPermgen;
    }

    public String getHeapSize() {
        return this.heapSize;
    }

    void setHeapSize(String heapSize) {
        this.heapSize = heapSize;
    }

    public String getMaxHeap() {
        return this.maxHeap;
    }

    void setMaxHeap(String maxHeap) {
        this.maxHeap = maxHeap;
    }

    public String getName() {
        return this.name;
    }

    public Boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    void setDebugEnabled(Boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public String getDebugOptions() {
        return this.debugOptions;
    }

    void setDebugOptions(String debugOptions) {
        this.debugOptions = debugOptions;
    }

    public String getStack() {
        return this.stack;
    }

    void setStack(String stack) {
        this.stack = stack;
    }

    public Boolean isEnvClasspathIgnored() {
        return this.envClasspathIgnored;
    }

    void setEnvClasspathIgnored(Boolean envClasspathIgnored) {
        this.envClasspathIgnored = envClasspathIgnored;
    }

    public JvmOptionsElement getJvmOptions() {
        return this.jvmOptionsElement;
    }

    public PropertiesElement getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public PropertiesElement getSystemProperties() {
        return this.systemProperties;
    }

    public String getAgentPath() {
        return this.agentPath;
    }

    void setAgentPath(String agentPath) {
        if (this.agentLib != null) {
            throw new IllegalArgumentException("Attempting to set 'agent-path' when 'agent-lib' was already set");
        }
        this.agentPath = agentPath;
    }

    public String getAgentLib() {
        return this.agentLib;
    }

    void setAgentLib(String agentLib) {
        if (this.agentPath != null) {
            throw new IllegalArgumentException("Attempting to set 'agent-lib' when 'agent-path' was already set");
        }
        this.agentLib = agentLib;
    }

    public String getJavaagent() {
        return this.javaagent;
    }

    void setJavaagent(String javaagent) {
        this.javaagent = javaagent;
    }

    @Override
    protected Class<JvmElement> getElementClass() {
        return JvmElement.class;
    }

    @Override
    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.name);
        if (this.javaHome != null) {
            streamWriter.writeAttribute(Attribute.JAVA_HOME.getLocalName(), this.javaHome);
        }
        if (this.type != null) {
            streamWriter.writeAttribute(Attribute.TYPE.getLocalName(), this.type.toString());
        }
        if (this.debugEnabled != null) {
            streamWriter.writeAttribute(Attribute.DEBUG_ENABLED.getLocalName(), this.debugEnabled.toString());
        }
        if (this.debugOptions != null) {
            streamWriter.writeAttribute(Attribute.DEBUG_OPTIONS.getLocalName(), this.debugOptions.toString());
        }
        if (this.envClasspathIgnored != null) {
            streamWriter.writeAttribute(Attribute.ENV_CLASSPATH_IGNORED.getLocalName(), this.envClasspathIgnored.toString());
        }
        if (this.heapSize != null || this.maxHeap != null) {
            streamWriter.writeEmptyElement(Element.HEAP.getLocalName());
            if (this.heapSize != null) {
                streamWriter.writeAttribute(Attribute.SIZE.getLocalName(), this.heapSize);
            }
            if (this.maxHeap != null) {
                streamWriter.writeAttribute(Attribute.MAX_SIZE.getLocalName(), this.maxHeap);
            }
        }
        if (this.permgenSize != null || this.maxPermgen != null) {
            streamWriter.writeEmptyElement(Element.PERMGEN.getLocalName());
            if (this.permgenSize != null) {
                streamWriter.writeAttribute(Attribute.SIZE.getLocalName(), this.permgenSize);
            }
            if (this.maxPermgen != null) {
                streamWriter.writeAttribute(Attribute.MAX_SIZE.getLocalName(), this.permgenSize);
            }
        }
        if (this.stack != null) {
            streamWriter.writeEmptyElement(Element.STACK.getLocalName());
            streamWriter.writeAttribute(Attribute.SIZE.getLocalName(), this.stack);
        }
        if (this.agentLib != null) {
            streamWriter.writeEmptyElement(Element.AGENT_LIB.getLocalName());
            streamWriter.writeAttribute(Attribute.VALUE.getLocalName(), this.agentLib);
        }
        if (this.agentPath != null) {
            streamWriter.writeEmptyElement(Element.AGENT_PATH.getLocalName());
            streamWriter.writeAttribute(Attribute.VALUE.getLocalName(), this.agentPath);
        }
        if (this.javaagent != null) {
            streamWriter.writeEmptyElement(Element.JAVA_AGENT.getLocalName());
            streamWriter.writeAttribute(Attribute.VALUE.getLocalName(), this.javaagent);
        }
        if (this.environmentVariables != null && this.environmentVariables.size() > 0) {
            streamWriter.writeStartElement(Element.ENVIRONMENT_VARIABLES.getLocalName());
            this.environmentVariables.writeContent(streamWriter);
        }
        if (this.systemProperties != null && this.systemProperties.size() > 0) {
            streamWriter.writeStartElement(Element.SYSTEM_PROPERTIES.getLocalName());
            this.systemProperties.writeContent(streamWriter);
        }
        streamWriter.writeEndElement();
    }

    private void parseMinMax(XMLExtendedStreamReader reader, MinMaxSetter setter) throws XMLStreamException {
        String size = null;
        String max = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    size = value;
                    continue block4;
                }
                case MAX_SIZE: {
                    max = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        setter.setMinMax(size, max);
        ParseUtils.requireNoContent(reader);
    }

    private void parseStack(XMLExtendedStreamReader reader) throws XMLStreamException {
        String size = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    size = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (size == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.SIZE));
        }
        this.stack = size;
        ParseUtils.requireNoContent(reader);
    }

    private String parseValue(XMLExtendedStreamReader reader) throws XMLStreamException {
        String found = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    found = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (found == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.VALUE));
        }
        ParseUtils.requireNoContent(reader);
        return found;
    }

    private class PermGenSetter
    implements MinMaxSetter {
        private PermGenSetter() {
        }

        @Override
        public void setMinMax(String min, String max) {
            JvmElement.this.permgenSize = min;
            JvmElement.this.maxHeap = max;
        }
    }

    private class HeapSetter
    implements MinMaxSetter {
        private HeapSetter() {
        }

        @Override
        public void setMinMax(String min, String max) {
            JvmElement.this.heapSize = min;
            JvmElement.this.maxHeap = max;
        }
    }

    private static interface MinMaxSetter {
        public void setMinMax(String var1, String var2);
    }
}

