/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Iterator;
import java.util.List;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractPropertyUpdate;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ServerElement;
import org.jboss.as.model.ServerSystemPropertyUpdate;
import org.jboss.as.model.UpdateFailedException;

public final class HostSystemPropertyUpdate
extends AbstractHostModelUpdate<Void> {
    private static final long serialVersionUID = -3412272237934071396L;
    private final AbstractPropertyUpdate propertyUpdate;

    public HostSystemPropertyUpdate(AbstractPropertyUpdate propertyUpdate) {
        this.propertyUpdate = propertyUpdate;
    }

    @Override
    protected void applyUpdate(HostModel element) throws UpdateFailedException {
        this.propertyUpdate.applyUpdate(element.getSystemProperties());
    }

    public HostSystemPropertyUpdate getCompensatingUpdate(HostModel original) {
        return new HostSystemPropertyUpdate(this.propertyUpdate.getCompensatingUpdate(original.getSystemProperties()));
    }

    public ServerSystemPropertyUpdate getServerModelUpdate() {
        return new ServerSystemPropertyUpdate(this.propertyUpdate);
    }

    @Override
    public List<String> getAffectedServers(HostModel hostModel) {
        String propertyName = this.propertyUpdate.getPropertyName();
        List<String> activeServers = hostModel.getActiveServerNames();
        Iterator<String> it = activeServers.iterator();
        while (it.hasNext()) {
            ServerElement server = hostModel.getServer(it.next());
            if (!server.getSystemProperties().getPropertyNames().contains(propertyName)) continue;
            it.remove();
        }
        return activeServers;
    }
}

