/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.HostServerRemove;
import org.jboss.as.model.UpdateFailedException;

public final class HostServerAdd
extends AbstractHostModelUpdate<Void> {
    private static final long serialVersionUID = 6075488950873140885L;
    private final String serverName;
    private final String groupName;

    public HostServerAdd(String serverName, String groupName) {
        this.serverName = serverName;
        this.groupName = groupName;
    }

    @Override
    protected void applyUpdate(HostModel element) throws UpdateFailedException {
        if (!element.addServer(this.serverName, this.groupName)) {
            throw new UpdateFailedException("Server " + this.serverName + " already configured");
        }
    }

    public HostServerRemove getCompensatingUpdate(HostModel original) {
        if (original.getServer(this.serverName) != null) {
            return null;
        }
        return new HostServerRemove(this.serverName);
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return null;
    }

    @Override
    public List<String> getAffectedServers(HostModel hostModel) {
        return Collections.emptyList();
    }
}

