/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Iterator;
import java.util.List;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.HostPathRemove;
import org.jboss.as.model.PathElement;
import org.jboss.as.model.PathElementUpdate;
import org.jboss.as.model.ServerElement;
import org.jboss.as.model.ServerPathAdd;
import org.jboss.as.model.UpdateFailedException;

public class HostPathAdd
extends AbstractHostModelUpdate<Void> {
    private static final long serialVersionUID = 1487178917602420851L;
    private final PathElementUpdate update;

    public HostPathAdd(PathElementUpdate update) {
        if (update == null) {
            throw new IllegalArgumentException("null path element update");
        }
        if (update.getPath() == null) {
            throw new IllegalArgumentException("null path for path element " + update.getName());
        }
        this.update = update;
    }

    @Override
    protected void applyUpdate(HostModel element) throws UpdateFailedException {
        PathElement path = element.addPath(this.update.getName());
        if (path == null) {
            throw new UpdateFailedException("duplicate path " + this.update.getName());
        }
        this.update.applyUpdate(path);
    }

    @Override
    public AbstractHostModelUpdate<?> getCompensatingUpdate(HostModel original) {
        return new HostPathRemove(this.update.getName());
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return new ServerPathAdd(this.update);
    }

    @Override
    public List<String> getAffectedServers(HostModel hostModel) {
        String pathName = this.update.getName();
        List<String> activeServers = hostModel.getActiveServerNames();
        Iterator<String> it = activeServers.iterator();
        while (it.hasNext()) {
            ServerElement server = hostModel.getServer(it.next());
            if (server.getPath(pathName) == null) continue;
            it.remove();
        }
        return activeServers;
    }
}

