/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModel;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.Attribute;
import org.jboss.as.model.Element;
import org.jboss.as.model.JvmElement;
import org.jboss.as.model.LocalDomainControllerElement;
import org.jboss.as.model.ManagementElement;
import org.jboss.as.model.Namespace;
import org.jboss.as.model.PathElement;
import org.jboss.as.model.PropertiesElement;
import org.jboss.as.model.RemoteDomainControllerElement;
import org.jboss.as.model.ServerElement;
import org.jboss.as.model.socket.InterfaceElement;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class HostModel
extends AbstractModel<HostModel> {
    private static final long serialVersionUID = 7667892965813702351L;
    public static final String DEFAULT_NAME;
    private final Set<String> extensions = new HashSet<String>();
    private final Map<String, InterfaceElement> interfaces = new LinkedHashMap<String, InterfaceElement>();
    private final Map<String, ServerElement> servers = new LinkedHashMap<String, ServerElement>();
    private final Map<String, JvmElement> jvms = new LinkedHashMap<String, JvmElement>();
    private final Map<String, PathElement> paths = new LinkedHashMap<String, PathElement>();
    private String configuredName;
    private LocalDomainControllerElement localDomainController;
    private RemoteDomainControllerElement remoteDomainController;
    private ManagementElement managementElement;
    private final PropertiesElement systemProperties = new PropertiesElement(Element.PROPERTY, true);
    private static final QName ELEMENT_NAME;

    public HostModel() {
        super(ELEMENT_NAME);
    }

    public JvmElement getJvm(String name) {
        return this.jvms.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterfaceElement getInterface(String name) {
        Map<String, InterfaceElement> map = this.interfaces;
        synchronized (map) {
            return this.interfaces.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<InterfaceElement> getInterfaces() {
        Map<String, InterfaceElement> map = this.interfaces;
        synchronized (map) {
            return new HashSet<InterfaceElement>(this.interfaces.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ServerElement> getServers() {
        Map<String, ServerElement> map = this.servers;
        synchronized (map) {
            return new HashSet<ServerElement>(this.servers.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getActiveServerNames() {
        ArrayList<String> result = new ArrayList<String>();
        Map<String, ServerElement> map = this.servers;
        synchronized (map) {
            for (Map.Entry<String, ServerElement> entry : this.servers.entrySet()) {
                if (!entry.getValue().isStart()) continue;
                result.add(entry.getKey());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerElement getServer(String name) {
        Map<String, ServerElement> map = this.servers;
        synchronized (map) {
            return this.servers.get(name);
        }
    }

    public PropertiesElement getSystemProperties() {
        return this.systemProperties;
    }

    public LocalDomainControllerElement getLocalDomainControllerElement() {
        return this.localDomainController;
    }

    public RemoteDomainControllerElement getRemoteDomainControllerElement() {
        return this.remoteDomainController;
    }

    public ManagementElement getManagementElement() {
        return this.managementElement;
    }

    public String getName() {
        return this.configuredName == null ? DEFAULT_NAME : this.configuredName;
    }

    public Collection<PathElement> getPaths() {
        return Collections.unmodifiableCollection(new HashSet<PathElement>(this.paths.values()));
    }

    public PathElement getPath(String name) {
        return this.paths.get(name);
    }

    @Override
    protected Class<HostModel> getElementClass() {
        return HostModel.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        if (this.configuredName != null) {
            streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.configuredName);
        }
        this.writeNamespaces(streamWriter);
        if (!this.extensions.isEmpty()) {
            streamWriter.writeStartElement(Element.EXTENSIONS.getLocalName());
            for (String string : this.extensions) {
                streamWriter.writeEmptyElement(Element.EXTENSION.getLocalName());
                streamWriter.writeAttribute(Attribute.MODULE.getLocalName(), string);
            }
            streamWriter.writeEndElement();
        }
        Iterator<AbstractModelElement> i$ = this.paths;
        synchronized (i$) {
            if (!this.paths.isEmpty()) {
                streamWriter.writeStartElement(Element.PATHS.getLocalName());
                for (PathElement path : this.paths.values()) {
                    streamWriter.writeStartElement(Element.PATH.getLocalName());
                    path.writeContent(streamWriter);
                }
                streamWriter.writeEndElement();
            }
        }
        if (this.systemProperties != null && this.systemProperties.size() > 0) {
            streamWriter.writeStartElement(Element.SYSTEM_PROPERTIES.getLocalName());
            this.systemProperties.writeContent(streamWriter);
        }
        streamWriter.writeStartElement(Element.MANAGEMENT.getLocalName());
        this.managementElement.writeContent(streamWriter);
        streamWriter.writeStartElement(Element.DOMAIN_CONTROLLER.getLocalName());
        if (this.localDomainController != null) {
            streamWriter.writeStartElement(Element.LOCAL.getLocalName());
            this.localDomainController.writeContent(streamWriter);
        } else if (this.remoteDomainController != null) {
            streamWriter.writeStartElement(Element.REMOTE.getLocalName());
            this.remoteDomainController.writeContent(streamWriter);
        }
        streamWriter.writeEndElement();
        if (!this.interfaces.isEmpty()) {
            streamWriter.writeStartElement(Element.INTERFACES.getLocalName());
            for (InterfaceElement interfaceElement : this.interfaces.values()) {
                streamWriter.writeStartElement(Element.INTERFACE.getLocalName());
                interfaceElement.writeContent(streamWriter);
            }
            streamWriter.writeEndElement();
        }
        if (!this.jvms.isEmpty()) {
            streamWriter.writeStartElement(Element.JVMS.getLocalName());
            for (JvmElement jvmElement : this.jvms.values()) {
                streamWriter.writeStartElement(Element.JVM.getLocalName());
                jvmElement.writeContent(streamWriter);
            }
            streamWriter.writeEndElement();
        }
        if (!this.servers.isEmpty()) {
            streamWriter.writeStartElement(Element.SERVERS.getLocalName());
            for (ServerElement serverElement : this.servers.values()) {
                streamWriter.writeStartElement(Element.SERVER.getLocalName());
                serverElement.writeContent(streamWriter);
            }
            streamWriter.writeEndElement();
        }
        streamWriter.writeEndElement();
    }

    boolean addExtension(String name) {
        return this.extensions.add(name);
    }

    boolean removeExtension(String name) {
        return this.extensions.remove(name);
    }

    Set<String> getExtensions() {
        return this.extensions;
    }

    InterfaceElement addInterface(String name) {
        if (this.interfaces.containsKey(name)) {
            return null;
        }
        InterfaceElement networkInterface = new InterfaceElement(name);
        this.interfaces.put(name, networkInterface);
        return networkInterface;
    }

    boolean removeInterface(String name) {
        return this.interfaces.remove(name) != null;
    }

    void setName(String name) {
        this.configuredName = name;
    }

    boolean addJvm(String jvmName) {
        if (this.jvms.containsKey(jvmName)) {
            return false;
        }
        this.jvms.put(jvmName, new JvmElement(jvmName));
        return true;
    }

    boolean removeJvm(String jvmName) {
        return this.jvms.remove(jvmName) != null;
    }

    boolean addManagementElement(String interfaceName, int port) {
        if (this.managementElement != null) {
            return false;
        }
        this.managementElement = new ManagementElement(interfaceName, port);
        return true;
    }

    boolean removeManagementElement() {
        if (this.managementElement != null) {
            this.managementElement = null;
            return true;
        }
        return false;
    }

    boolean addRemoteDomainController(String host, int port) {
        if (this.localDomainController != null || this.remoteDomainController != null) {
            return false;
        }
        this.remoteDomainController = new RemoteDomainControllerElement(host, port);
        return true;
    }

    boolean removeRemoteDomainController() {
        if (this.remoteDomainController == null) {
            return false;
        }
        this.remoteDomainController = null;
        return true;
    }

    boolean addLocalDomainController() {
        if (this.localDomainController != null || this.remoteDomainController != null) {
            return false;
        }
        this.localDomainController = new LocalDomainControllerElement();
        return true;
    }

    boolean removeLocalDomainController() {
        if (this.localDomainController == null) {
            return false;
        }
        this.localDomainController = null;
        return true;
    }

    boolean addServer(String serverName, String groupName) {
        if (this.servers.containsKey(serverName)) {
            return false;
        }
        this.servers.put(serverName, new ServerElement(serverName, groupName));
        return true;
    }

    boolean removeServer(String serverName) {
        return this.servers.remove(serverName) != null;
    }

    PathElement addPath(String name) {
        if (this.paths.containsKey(name)) {
            return null;
        }
        PathElement element = new PathElement(name);
        this.paths.put(name, element);
        return element;
    }

    boolean removePath(String name) {
        return this.paths.remove(name) != null;
    }

    static {
        try {
            DEFAULT_NAME = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        ELEMENT_NAME = new QName(Namespace.CURRENT.getUriString(), Element.HOST.getLocalName());
    }
}

