/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.HostJvmAdd;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.UpdateFailedException;

public final class HostJvmRemove
extends AbstractHostModelUpdate<Void> {
    private static final long serialVersionUID = 6075488950873140885L;
    private final String jvmName;

    public HostJvmRemove(String jvmName) {
        this.jvmName = jvmName;
    }

    @Override
    protected void applyUpdate(HostModel element) throws UpdateFailedException {
        if (!element.removeJvm(this.jvmName)) {
            throw new UpdateFailedException("JVM " + this.jvmName + " was not configured");
        }
    }

    public HostJvmAdd getCompensatingUpdate(HostModel original) {
        if (original.getJvm(this.jvmName) != null) {
            return new HostJvmAdd(this.jvmName);
        }
        return null;
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return null;
    }

    @Override
    public List<String> getAffectedServers(HostModel hostModel) {
        return Collections.emptyList();
    }
}

