/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.DomainSubsystemAdd;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ProfileElement;
import org.jboss.as.model.ServerSubsystemRemove;
import org.jboss.as.model.SubsystemRemove;
import org.jboss.as.model.UpdateFailedException;

public final class DomainSubsystemRemove
extends AbstractDomainModelUpdate<Void> {
    private static final long serialVersionUID = -9076890219875153928L;
    private final String profileName;
    private final SubsystemRemove subsystemRemove;

    public DomainSubsystemRemove(String profileName, SubsystemRemove subsystemRemove) {
        this.profileName = profileName;
        this.subsystemRemove = subsystemRemove;
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
        ProfileElement profileElement = element.getProfile(this.profileName);
        if (profileElement == null) {
            throw new UpdateFailedException("Profile '" + this.profileName + "' is not configured on this domain");
        }
        this.subsystemRemove.applyUpdate(profileElement);
    }

    public String getProfileName() {
        return this.profileName;
    }

    public SubsystemRemove getSubsystemRemove() {
        return this.subsystemRemove;
    }

    public String getNamespaceUri() {
        return this.subsystemRemove.getNamespaceUri();
    }

    public DomainSubsystemAdd getCompensatingUpdate(DomainModel original) {
        return new DomainSubsystemAdd(this.profileName, this.subsystemRemove.getCompensatingUpdate(original.getProfile(this.profileName)));
    }

    public ServerSubsystemRemove getServerModelUpdate() {
        return new ServerSubsystemRemove(this.subsystemRemove);
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        if (this.getServerModelUpdate() == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String server : hostModel.getActiveServerNames()) {
            String serverGroupName = hostModel.getServer(server).getServerGroup();
            if (!this.profileName.equals(domainModel.getServerGroup(serverGroupName).getProfileName())) continue;
            result.add(server);
        }
        return result;
    }
}

