/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.DomainSocketBindingGroupRemove;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.socket.SocketBindingGroupElement;
import org.jboss.as.model.socket.SocketBindingGroupUpdate;

public class DomainSocketBindingGroupAdd
extends AbstractDomainModelUpdate<Void> {
    private static final long serialVersionUID = 6748745991529958637L;
    private final SocketBindingGroupUpdate update;

    public DomainSocketBindingGroupAdd(SocketBindingGroupUpdate update) {
        this.update = update;
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
        SocketBindingGroupElement bindingGroup = element.addSocketBindingGroup(this.update.getName());
        if (bindingGroup == null) {
            throw new UpdateFailedException("duplicate binding-group " + this.update.getName());
        }
        this.update.applyUpdate(bindingGroup);
    }

    @Override
    public AbstractDomainModelUpdate<?> getCompensatingUpdate(DomainModel domain) {
        return new DomainSocketBindingGroupRemove(this.update.getName());
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return null;
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        return Collections.emptyList();
    }
}

