/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.DomainPathAdd;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.PathElement;
import org.jboss.as.model.PathElementUpdate;
import org.jboss.as.model.ServerPathRemove;
import org.jboss.as.model.UpdateFailedException;

public class DomainPathRemove
extends AbstractDomainModelUpdate<Void> {
    private static final long serialVersionUID = -4310868265566084137L;
    private final String name;

    public DomainPathRemove(String name) {
        this.name = name;
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
        if (!element.removePath(this.name)) {
            throw new UpdateFailedException(String.format("path (%s) does not exist", this.name));
        }
    }

    @Override
    public AbstractDomainModelUpdate<?> getCompensatingUpdate(DomainModel original) {
        PathElement path = original.getPath(this.name);
        if (path == null) {
            return null;
        }
        return new DomainPathAdd(new PathElementUpdate(this.name, path.getPath(), path.getRelativeTo()));
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return new ServerPathRemove(this.name);
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        return Collections.emptyList();
    }
}

