/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DomainInterfaceRemove;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ServerModelInterfaceAdd;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.socket.InterfaceAdd;
import org.jboss.as.model.socket.InterfaceElement;

public class DomainInterfaceAdd
extends AbstractDomainModelUpdate<Void> {
    private static final long serialVersionUID = -8081711642455069769L;
    private final InterfaceAdd delegate;

    public DomainInterfaceAdd(InterfaceAdd delegate) {
        this.delegate = delegate;
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
        InterfaceElement networkInterface = element.addInterface(this.delegate.getName());
        if (networkInterface == null) {
            throw new UpdateFailedException("duplicate interface binding " + this.delegate.getName());
        }
        this.delegate.applyUpdate(networkInterface);
    }

    @Override
    public AbstractDomainModelUpdate<?> getCompensatingUpdate(DomainModel original) {
        return new DomainInterfaceRemove(this.delegate.getName());
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return new ServerModelInterfaceAdd(this.delegate);
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        if (!this.delegate.isFullySpecified()) {
            return Collections.emptyList();
        }
        if (hostModel.getInterface(this.delegate.getName()) != null) {
            return Collections.emptyList();
        }
        return hostModel.getActiveServerNames();
    }
}

