/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DeploymentUnitElement;
import org.jboss.as.model.DomainDeploymentAdd;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.UpdateFailedException;

public final class DomainDeploymentRemove
extends AbstractDomainModelUpdate<Void> {
    private static final long serialVersionUID = -9076890219875153928L;
    private final String uniqueName;

    public DomainDeploymentRemove(String uniqueName) {
        if (uniqueName == null) {
            throw new IllegalArgumentException("uniqueName is null");
        }
        this.uniqueName = uniqueName;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
        Set<String> mappings = element.getServerGroupDeploymentsMappings(this.uniqueName);
        if (mappings.size() > 0) {
            Iterator<String> iter = mappings.iterator();
            StringBuffer sb = new StringBuffer(iter.next());
            while (iter.hasNext()) {
                sb.append(", ");
                sb.append(iter.next());
            }
            throw new UpdateFailedException("Deployment " + this.uniqueName + " cannot be removed as it is mapped to server groups " + sb.toString());
        }
        if (!element.removeDeployment(this.uniqueName)) {
            throw new UpdateFailedException("Deployment '" + this.uniqueName + "' is not configured");
        }
    }

    public DomainDeploymentAdd getCompensatingUpdate(DomainModel original) {
        DeploymentUnitElement due = original.getDeployment(this.uniqueName);
        return due == null ? null : new DomainDeploymentAdd(this.uniqueName, due.getRuntimeName(), due.getSha1Hash(), due.isStart());
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return null;
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        return Collections.emptyList();
    }
}

