/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ServerElement;
import org.jboss.as.model.ServerGroupDeploymentElement;
import org.jboss.as.model.ServerGroupElement;
import org.jboss.as.model.ServerModelDeploymentReplaceUpdate;
import org.jboss.as.model.UpdateFailedException;

public final class DomainDeploymentRedeployUpdate
extends AbstractDomainModelUpdate<Void> {
    private static final long serialVersionUID = -9076890219875153928L;
    private final String uniqueName;

    public DomainDeploymentRedeployUpdate(String uniqueName) {
        if (uniqueName == null) {
            throw new IllegalArgumentException("uniqueName is null");
        }
        this.uniqueName = uniqueName;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
    }

    public DomainDeploymentRedeployUpdate getCompensatingUpdate(DomainModel original) {
        return this;
    }

    public ServerModelDeploymentReplaceUpdate getServerModelUpdate() {
        return new ServerModelDeploymentReplaceUpdate(this.uniqueName, this.uniqueName);
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        HashSet<String> groupNames = new HashSet<String>(domainModel.getServerGroupNames());
        Iterator it = groupNames.iterator();
        while (it.hasNext()) {
            String groupName = (String)it.next();
            ServerGroupElement group = domainModel.getServerGroup(groupName);
            ServerGroupDeploymentElement sgde = group.getDeployment(this.uniqueName);
            if (sgde != null) continue;
            it.remove();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String serverName : hostModel.getActiveServerNames()) {
            ServerElement server = hostModel.getServer(serverName);
            if (!groupNames.contains(server.getServerGroup())) continue;
            result.add(serverName);
        }
        return result;
    }
}

