/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.processor;

import java.io.Closeable;
import java.io.InputStream;
import java.util.List;
import org.jboss.as.deployment.AttachmentKey;
import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.attachment.VirtualFileAttachment;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.SuffixMatchFilter;

public class AnnotationIndexProcessor
implements DeploymentUnitProcessor {
    public static final AttachmentKey<Index> ATTACHMENT_KEY = new AttachmentKey<Index>(Index.class);
    public static final long PRIORITY = DeploymentPhases.PARSE_DESCRIPTORS.plus(200L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        if (context.getAttachment(ATTACHMENT_KEY) != null) {
            return;
        }
        VirtualFile virtualFile = VirtualFileAttachment.getVirtualFileAttachment(context);
        Indexer indexer = new Indexer();
        try {
            List classChildren = virtualFile.getChildren((VirtualFileFilter)new SuffixMatchFilter(".class", VisitorAttributes.RECURSE_LEAVES_ONLY));
            for (VirtualFile classFile : classChildren) {
                InputStream inputStream = null;
                try {
                    inputStream = classFile.openStream();
                    indexer.index(inputStream);
                }
                finally {
                    VFSUtils.safeClose((Closeable)inputStream);
                }
            }
            Index index = indexer.complete();
            context.putAttachment(ATTACHMENT_KEY, index);
        }
        catch (Throwable t) {
            throw new DeploymentUnitProcessingException("Failed to index deployment root for annotations", t);
        }
    }
}

