/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.module;

import java.io.IOException;
import org.jboss.as.deployment.AttachmentKey;
import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.module.DeploymentModuleLoader;
import org.jboss.as.deployment.module.DeploymentModuleLoaderProcessor;
import org.jboss.as.deployment.module.ModuleConfig;
import org.jboss.as.deployment.module.VFSResourceLoader;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.StartException;

public class ModuleDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.MODULARIZE.plus(750L);
    public static final AttachmentKey<Module> MODULE_ATTACHMENT_KEY = new AttachmentKey<Module>(Module.class);

    @Override
    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        ModuleConfig.Dependency[] dependencies;
        if (context.getAttachment(MODULE_ATTACHMENT_KEY) != null) {
            return;
        }
        ModuleConfig moduleConfig = context.getAttachment(ModuleConfig.ATTACHMENT_KEY);
        if (moduleConfig == null) {
            return;
        }
        ModuleIdentifier moduleIdentifier = moduleConfig.getIdentifier();
        ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)moduleIdentifier);
        for (ModuleConfig.ResourceRoot resource : moduleConfig.getResources()) {
            try {
                specBuilder.addResourceRoot((ResourceLoader)new VFSResourceLoader(specBuilder.getIdentifier(), resource.getRootName(), resource.getRoot(), resource.getMountHandle()));
            }
            catch (IOException e) {
                throw new DeploymentUnitProcessingException("Failed to create VFSResourceLoader for root [" + resource.getRootName() + "]", e);
            }
        }
        DeploymentModuleLoader deploymentModuleLoader = context.getAttachment(DeploymentModuleLoaderProcessor.ATTACHMENT_KEY);
        for (ModuleConfig.Dependency dependency : dependencies = moduleConfig.getDependencies()) {
            DependencySpec depSpec = DependencySpec.createModuleDependencySpec((ModuleIdentifier)dependency.getIdentifier(), (boolean)dependency.isExport(), (boolean)dependency.isOptional());
            specBuilder.addDependency(depSpec);
        }
        specBuilder.addDependency(DependencySpec.createLocalDependencySpec());
        ModuleSpec moduleSpec = specBuilder.create();
        deploymentModuleLoader.addModuleSpec(moduleSpec);
        try {
            Module module = deploymentModuleLoader.loadModule(moduleIdentifier);
            context.putAttachment(MODULE_ATTACHMENT_KEY, module);
            context.getBatchServiceBuilder().addListener((ServiceListener)new ModuleRemoveListener(deploymentModuleLoader, module));
        }
        catch (ModuleLoadException e) {
            throw new DeploymentUnitProcessingException("Failed to load module: " + moduleIdentifier, e);
        }
    }

    static class ModuleRemoveListener
    implements ServiceListener<Void> {
        private DeploymentModuleLoader deploymentModuleLoader;
        private Module module;

        ModuleRemoveListener(DeploymentModuleLoader deploymentModuleLoader, Module module) {
            this.deploymentModuleLoader = deploymentModuleLoader;
            this.module = module;
        }

        public void serviceStopped(ServiceController<? extends Void> controller) {
            this.deploymentModuleLoader.removeModule(this.module);
        }

        public void listenerAdded(ServiceController<? extends Void> controller) {
        }

        public void serviceStarting(ServiceController<? extends Void> controller) {
        }

        public void serviceStarted(ServiceController<? extends Void> controller) {
        }

        public void serviceFailed(ServiceController<? extends Void> controller, StartException reason) {
        }

        public void serviceStopping(ServiceController<? extends Void> controller) {
        }

        public void serviceRemoved(ServiceController<? extends Void> controller) {
        }
    }
}

