/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.module;

import java.io.Serializable;
import org.jboss.as.deployment.AttachmentKey;
import org.jboss.as.deployment.module.MountHandle;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.vfs.VirtualFile;

public final class ModuleConfig
implements Serializable {
    public static final AttachmentKey<ModuleConfig> ATTACHMENT_KEY = AttachmentKey.create(ModuleConfig.class);
    private static final long serialVersionUID = 210753378958448029L;
    private final ModuleIdentifier identifier;
    private final Dependency[] dependencies;
    private final ResourceRoot[] resources;

    public ModuleConfig(ModuleIdentifier identifier, Dependency[] dependencies, ResourceRoot[] resources) {
        this.identifier = identifier;
        this.dependencies = dependencies;
        this.resources = resources;
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public Dependency[] getDependencies() {
        return this.dependencies;
    }

    public ResourceRoot[] getResources() {
        return this.resources;
    }

    public static final class ResourceRoot
    implements Serializable {
        private static final long serialVersionUID = 3458831155403388498L;
        private final String rootName;
        private final VirtualFile root;
        private final MountHandle mountHandle;

        public ResourceRoot(VirtualFile root, MountHandle mountHandle) {
            this(root.getName(), root, mountHandle);
        }

        public ResourceRoot(String rootName, VirtualFile root, MountHandle mountHandle) {
            this.rootName = rootName;
            this.root = root;
            this.mountHandle = mountHandle;
        }

        public String getRootName() {
            return this.rootName;
        }

        public VirtualFile getRoot() {
            return this.root;
        }

        public MountHandle getMountHandle() {
            return this.mountHandle;
        }
    }

    public static final class Dependency
    implements Serializable {
        private static final long serialVersionUID = 2749276798703740853L;
        private final ModuleIdentifier identifier;
        private final boolean export;
        private final boolean optional;
        private final boolean staticModule;

        public Dependency(ModuleIdentifier identifier, boolean staticModule, boolean optional, boolean export) {
            this.identifier = identifier;
            this.staticModule = staticModule;
            this.optional = optional;
            this.export = export;
        }

        public ModuleIdentifier getIdentifier() {
            return this.identifier;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean isExport() {
            return this.export;
        }

        public boolean isStatic() {
            return this.staticModule;
        }
    }
}

