/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.chain;

import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.jboss.as.deployment.chain.DeploymentChain;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;

public class DeploymentChainImpl
implements DeploymentChain {
    private final Set<OrderedProcessor> orderedProcessors = new ConcurrentSkipListSet<OrderedProcessor>();
    private final String name;

    public DeploymentChainImpl(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        Set<OrderedProcessor> processors = this.orderedProcessors;
        for (OrderedProcessor orderedProcessor : processors) {
            orderedProcessor.processor.processDeployment(context);
        }
    }

    @Override
    public void addProcessor(DeploymentUnitProcessor processor, long priority) {
        Set<OrderedProcessor> processors = this.orderedProcessors;
        if (!processors.add(new OrderedProcessor(processor, priority))) {
            throw new IllegalArgumentException("Duplicate processor name and priority: " + processor.getClass().getSimpleName() + ":" + priority);
        }
    }

    @Override
    public void removeProcessor(DeploymentUnitProcessor processor, long priority) {
        this.orderedProcessors.remove(new OrderedProcessor(processor, priority));
    }

    public String toString() {
        return "DeploymentChainImpl{name='" + this.name + "' processors=" + this.orderedProcessors + "}";
    }

    private static final class OrderedProcessor
    implements Comparable<OrderedProcessor> {
        private final DeploymentUnitProcessor processor;
        private final String name;
        private final long processingOrder;

        private OrderedProcessor(DeploymentUnitProcessor processor, long processingOrder) {
            if (processor == null) {
                throw new IllegalArgumentException("Processor can not be null");
            }
            this.processor = processor;
            this.name = processor.getClass().getName();
            this.processingOrder = processingOrder;
        }

        @Override
        public int compareTo(OrderedProcessor other) {
            long diff = this.processingOrder - other.processingOrder;
            return diff != 0L ? (diff < 0L ? -1 : 1) : this.name.compareTo(other.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OrderedProcessor)) {
                return false;
            }
            OrderedProcessor that = (OrderedProcessor)o;
            return this.processingOrder == that.processingOrder && this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (int)(this.processingOrder ^ this.processingOrder >>> 32);
            return result;
        }

        public String toString() {
            return this.processingOrder + " => " + this.processor;
        }
    }
}

