/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;

public class DeploymentFailureListener
extends AbstractServiceListener<Object> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.deployment");
    private final AtomicBoolean deploymentStopped = new AtomicBoolean();
    private final ServiceName deploymentServiceName;

    public DeploymentFailureListener(ServiceName deploymentServiceName) {
        this.deploymentServiceName = deploymentServiceName;
    }

    public void serviceFailed(ServiceController<?> serviceController, StartException reason) {
        if (this.deploymentStopped.compareAndSet(false, true)) {
            log.errorf((Throwable)reason, "Deployment [%s] failed to start correctly.  Completely shutting down deployment.  Please see additional errors for details.", (Object)this.deploymentServiceName);
            ServiceContainer serviceContainer = serviceController.getServiceContainer();
            ServiceController deploymentService = serviceContainer.getService(this.deploymentServiceName);
            if (deploymentService != null) {
                deploymentService.setMode(ServiceController.Mode.NEVER);
            }
        }
    }
}

