/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.domain.controller.operations.coordination.PrepareStepHandler;
import org.jboss.dmr.ModelNode;

class ProxyTask
implements Callable<ModelNode> {
    private final ProxyController proxyController;
    private final String host;
    private final ModelNode operation;
    private final OperationContext context;
    private final AtomicReference<Boolean> transactionAction = new AtomicReference();
    private final AtomicReference<ModelNode> uncommittedResultRef = new AtomicReference();
    private boolean cancelRemoteTransaction;

    public ProxyTask(String host, ModelNode operation, OperationContext context, ProxyController proxyController) {
        this.host = host;
        this.operation = operation;
        this.context = context;
        this.proxyController = proxyController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelNode call() throws Exception {
        boolean trace = PrepareStepHandler.isTraceEnabled();
        if (trace) {
            PrepareStepHandler.log.trace((Object)("Sending " + this.operation + " to " + this.host));
        }
        DelegatingMessageHandler messageHandler = new DelegatingMessageHandler(this.context);
        final AtomicReference txRef = new AtomicReference();
        final AtomicReference preparedResultRef = new AtomicReference();
        final AtomicReference finalResultRef = new AtomicReference();
        ProxyController.ProxyOperationControl proxyControl = new ProxyController.ProxyOperationControl(){

            public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                txRef.set(transaction);
                preparedResultRef.set(result);
            }

            public void operationFailed(ModelNode response) {
                finalResultRef.set(response);
            }

            public void operationCompleted(ModelNode response) {
                finalResultRef.set(response);
            }
        };
        this.proxyController.execute(this.operation, (OperationMessageHandler)messageHandler, proxyControl, (OperationAttachments)new DelegatingOperationAttachments(this.context));
        ModelController.OperationTransaction remoteTransaction = null;
        ModelNode result = (ModelNode)finalResultRef.get();
        if (result != null) {
            if (trace) {
                PrepareStepHandler.log.trace((Object)("Received final result " + result + " from " + this.host));
            }
        } else {
            result = (ModelNode)preparedResultRef.get();
            if (trace) {
                PrepareStepHandler.log.trace((Object)("Received prepared result " + result + " from " + this.host));
            }
            remoteTransaction = (ModelController.OperationTransaction)txRef.get();
        }
        AtomicReference<Object> atomicReference = this.uncommittedResultRef;
        synchronized (atomicReference) {
            this.uncommittedResultRef.set(result);
            this.uncommittedResultRef.notifyAll();
        }
        if (remoteTransaction != null) {
            if (this.cancelRemoteTransaction) {
                remoteTransaction.rollback();
            } else {
                atomicReference = this.transactionAction;
                synchronized (atomicReference) {
                    while (this.transactionAction.get() == null) {
                        try {
                            this.transactionAction.wait();
                        }
                        catch (InterruptedException ie) {
                            this.transactionAction.set(Boolean.FALSE);
                        }
                    }
                    if (this.transactionAction.get().booleanValue()) {
                        remoteTransaction.commit();
                    } else {
                        remoteTransaction.rollback();
                    }
                }
            }
        }
        return (ModelNode)finalResultRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ModelNode getUncommittedResult() throws InterruptedException {
        AtomicReference<ModelNode> atomicReference = this.uncommittedResultRef;
        synchronized (atomicReference) {
            while (this.uncommittedResultRef.get() == null) {
                try {
                    this.uncommittedResultRef.wait();
                }
                catch (InterruptedException ie) {
                    this.cancelRemoteTransaction = true;
                    throw ie;
                }
            }
            return this.uncommittedResultRef.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finalizeTransaction(boolean commit) {
        AtomicReference<Boolean> atomicReference = this.transactionAction;
        synchronized (atomicReference) {
            this.transactionAction.set(commit);
            this.transactionAction.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        AtomicReference<ModelNode> atomicReference = this.uncommittedResultRef;
        synchronized (atomicReference) {
            this.cancelRemoteTransaction = true;
        }
    }

    private static class DelegatingOperationAttachments
    implements OperationAttachments {
        private final OperationContext context;

        private DelegatingOperationAttachments(OperationContext context) {
            this.context = context;
        }

        public List<InputStream> getInputStreams() {
            int count = this.context.getAttachmentStreamCount();
            ArrayList<InputStream> result = new ArrayList<InputStream>(count);
            for (int i = 0; i < count; ++i) {
                result.add(this.context.getAttachmentStream(i));
            }
            return result;
        }
    }

    private static class DelegatingMessageHandler
    implements OperationMessageHandler {
        private final OperationContext context;

        DelegatingMessageHandler(OperationContext context) {
            this.context = context;
        }

        public void handleReport(MessageSeverity severity, String message) {
            this.context.report(severity, message);
        }
    }
}

