/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.domain.controller.operations.SystemPropertyRemoveHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SystemPropertyAddHandler
extends org.jboss.as.controller.operations.common.SystemPropertyAddHandler {
    public static final SystemPropertyAddHandler INSTANCE = new SystemPropertyAddHandler();
    private final ParametersValidator validator = new ParametersValidator();

    public static ModelNode getOperation(ModelNode address, String name, String value, boolean boottime) {
        ModelNode op = Util.getEmptyOperation((String)"add-system-property", (ModelNode)address);
        op.get("name").set(name);
        if (value == null) {
            op.get("value").set(new ModelNode());
        } else {
            op.get("value").set(value);
        }
        op.get("boot-time").set(boottime);
        return op;
    }

    protected SystemPropertyAddHandler() {
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
        this.validator.registerValidator("value", (ParameterValidator)new StringLengthValidator(0, true));
        this.validator.registerValidator("boot-time", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true));
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        this.validator.validate(operation);
        String name = operation.get("name").asString();
        String value = operation.get("value").isDefined() ? operation.get("value").asString() : null;
        boolean boottime = operation.get("boot-time").isDefined() ? operation.get("boot-time").asBoolean() : true;
        ModelNode node = context.getSubModel().get(new String[]{"system-properties", name});
        if (value == null) {
            node.get("value").set(new ModelNode());
        } else {
            node.get("value").set(value);
        }
        node.get("boot-time").set(boottime);
        ModelNode compensating = SystemPropertyRemoveHandler.getOperation(operation.get("address"), name);
        return this.updateSystemProperty(name, value, context, resultHandler, compensating);
    }

    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getAddSystemPropertyOperation((Locale)locale, (boolean)false);
    }

    protected OperationResult updateSystemProperty(final String name, final String value, OperationContext context, final ResultHandler resultHandler, ModelNode compensating) {
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    System.setProperty(name, value);
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensating);
    }
}

