/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.as.controller.AbstractModelController;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ControllerTransaction;
import org.jboss.as.controller.ControllerTransactionContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.DomainControllerSlave;
import org.jboss.as.domain.controller.DomainControllerSlaveClient;
import org.jboss.as.domain.controller.DomainModel;
import org.jboss.as.domain.controller.DomainModelImpl;
import org.jboss.as.domain.controller.FallbackRepository;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.domain.controller.MasterDomainControllerClient;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.operations.deployment.DeploymentUploadUtil;
import org.jboss.as.domain.controller.plan.RolloutPlanController;
import org.jboss.as.domain.controller.plan.ServerOperationExecutor;
import org.jboss.as.server.deployment.api.DeploymentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;

public class DomainControllerImpl
extends AbstractModelController<Void>
implements DomainController,
DomainControllerSlave {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.domain.controller");
    private static final Set<String> READ_ONLY_OPERATIONS;
    private static final Set<String> DEPLOYMENT_OPS;
    private final Map<String, DomainControllerSlaveClient> hosts;
    private final String localHostName;
    private final DomainModel localDomainModel;
    private final ScheduledExecutorService scheduledExecutorService;
    private final FileRepository fileRepository;
    private final DeploymentRepository deploymentRepository;
    private final MasterDomainControllerClient masterDomainControllerClient;
    private final ServerOperationExecutor serverOperationExecutor = new ServerOperationExecutor(){

        @Override
        public ModelNode executeServerOperation(ServerIdentity server, Operation operation) {
            return DomainControllerImpl.this.executeOnHost(server.getHostName(), operation, null);
        }
    };

    public DomainControllerImpl(ScheduledExecutorService scheduledExecutorService, DomainModel domainModel, String hostName, FileRepository fileRepository, DeploymentRepository deploymentRepository, Map<String, DomainControllerSlaveClient> hosts) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.localHostName = hostName;
        this.localDomainModel = domainModel;
        this.hosts = hosts;
        this.hosts.put(hostName, new LocalDomainModelAdapter());
        this.fileRepository = fileRepository;
        this.deploymentRepository = deploymentRepository;
        this.masterDomainControllerClient = null;
    }

    public DomainControllerImpl(ScheduledExecutorService scheduledExecutorService, DomainModel domainModel, String hostName, FileRepository fileRepository, MasterDomainControllerClient masterDomainControllerClient, Map<String, DomainControllerSlaveClient> hosts) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.masterDomainControllerClient = masterDomainControllerClient;
        this.localHostName = hostName;
        this.localDomainModel = domainModel;
        this.fileRepository = new FallbackRepository(fileRepository, masterDomainControllerClient.getRemoteFileRepository());
        this.hosts = hosts;
        this.hosts.put(hostName, new LocalDomainModelAdapter());
        this.deploymentRepository = null;
    }

    @Override
    public ModelNode addClient(DomainControllerSlaveClient client) {
        Logger.getLogger((String)"org.jboss.domain").info((Object)("register host " + client.getId()));
        if (this.hosts.containsKey(client.getId()) || this.localHostName.equals(client.getId())) {
            throw new IllegalArgumentException("There is already a host named '" + client.getId() + "'");
        }
        this.hosts.put(client.getId(), client);
        return this.localDomainModel.getDomainModel();
    }

    @Override
    public void removeClient(String id) {
        Logger.getLogger((String)"org.jboss.domain").info((Object)("unregister host " + id));
        this.hosts.remove(id);
    }

    @Override
    public ModelNode getProfileOperations(String profileName) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("describe");
        operation.get("address").set(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"profile", (String)profileName)}).toModelNode());
        try {
            ModelNode rsp = this.localDomainModel.execute(OperationBuilder.Factory.create((ModelNode)operation).build());
            if (!rsp.hasDefined("outcome") || !"success".equals(rsp.get("outcome").asString())) {
                ModelNode msgNode = rsp.get("failure-description");
                String msg = msgNode.isDefined() ? msgNode.toString() : "Failed to retrieve profile operations from domain controller";
                throw new RuntimeException(msg);
            }
            return rsp.require("result");
        }
        catch (CancellationException e) {
            throw new RuntimeException(e);
        }
    }

    public ModelNode execute(Operation operation, ControllerTransactionContext transaction) {
        return this.localDomainModel.executeForDomain(operation, transaction);
    }

    public OperationResult execute(Operation operation, ResultHandler handler, ControllerTransactionContext transaction) {
        throw new UnsupportedOperationException("Transactional operations with a passed in ResultHandler are not supported");
    }

    public OperationResult execute(Operation operation, ResultHandler handler, Void handback) {
        try {
            ModelNode operationNode = operation.getOperation();
            OperationRouting routing = this.determineRouting(operationNode);
            if ((routing.isRouteToMaster() || !routing.isLocalOnly()) && this.masterDomainControllerClient != null) {
                PathAddress addr = PathAddress.pathAddress((ModelNode)operationNode.get("address"));
                handler.handleFailed(new ModelNode().set("Operations for address " + addr + " can only handled by the master Domain Controller; this host is not the master Domain Controller"));
                return new BasicOperationResult();
            }
            if (!routing.isTwoStep()) {
                String host = routing.getSingleHost();
                return this.executeOnHost(host, operation, handler);
            }
            return this.executeTwoPhaseOperation(operation, handler, operationNode, routing);
        }
        catch (OperationFailedException e) {
            log.debugf((Throwable)e, "operation (%s) failed - address: (%s)", (Object)operation.getOperation().get("operation"), (Object)operation.getOperation().get("address"));
            handler.handleFailed(e.getFailureDescription());
            return new BasicOperationResult();
        }
        catch (Throwable t) {
            log.errorf(t, "operation (%s) failed - address: (%s)", (Object)operation.getOperation().get("operation"), (Object)operation.getOperation().get("address"));
            handler.handleFailed(this.getFailureResult(t));
            return new BasicOperationResult();
        }
    }

    private OperationResult executeTwoPhaseOperation(Operation operation, ResultHandler handler, ModelNode operationNode, OperationRouting routing) throws OperationFailedException {
        DomainLevelResult domainResult = this.executeOnDomainControllers(operation, handler, routing);
        if (domainResult.singleHostResult != null) {
            List steps;
            if (domainResult.singleHostResult.hasDefined("domain-results") && !domainResult.singleHostResult.hasDefined("server-operations") && (steps = domainResult.singleHostResult.get("domain-results").asPropertyList()).size() == 1) {
                ModelNode fragment = domainResult.singleHostResult.get("domain-results").get("step-1");
                handler.handleResultFragment(Util.NO_LOCATION, fragment);
            }
            handler.handleResultComplete();
            return new BasicOperationResult(domainResult.compensatingOperation);
        }
        RolloutPlanController controller = new RolloutPlanController(domainResult.opsByGroup, domainResult.rolloutPlan, handler, this.serverOperationExecutor, this.scheduledExecutorService, false);
        RolloutPlanController.Result controllerResult = controller.execute();
        switch (controllerResult) {
            case FAILED: {
                controller.rollback();
                handler.handleFailed(new ModelNode().set("Operation was not applied successfully to any servers"));
                return new BasicOperationResult(domainResult.compensatingOperation);
            }
            case PARTIAL: {
                controller.rollback();
            }
            case SUCCESS: {
                handler.handleResultComplete();
                return new BasicOperationResult(domainResult.compensatingOperation);
            }
        }
        throw new IllegalStateException(String.format("Unknown %s %s", new Object[]{RolloutPlanController.Result.class.getCanonicalName(), controllerResult}));
    }

    private DomainLevelResult executeOnDomainControllers(Operation operation, ResultHandler handler, OperationRouting routing) throws OperationFailedException {
        ControllerTransaction transaction = new ControllerTransaction();
        try {
            DomainLevelResult result;
            ModelNode operationNode = operation.getOperation();
            ModelNode rolloutPlan = operationNode.hasDefined("operation-headers") && operationNode.get("operation-headers").has("rollout-plan") ? operationNode.get("operation-headers").remove("rollout-plan") : null;
            Map<String, ModelNode> hostResults = null;
            try {
                hostResults = this.pushToHosts(operation, routing, transaction);
            }
            catch (Exception e) {
                ModelNode failureMsg = new ModelNode();
                failureMsg.get("domain-failure-description").set(e.toString());
                throw new OperationFailedException(failureMsg);
            }
            ModelNode masterFailureResult = null;
            ModelNode hostFailureResults = null;
            ModelNode masterResult = hostResults.get(this.localHostName);
            if (masterResult != null && masterResult.hasDefined("outcome") && "failed".equals(masterResult.get("outcome").asString())) {
                transaction.setRollbackOnly();
                masterFailureResult = masterResult.hasDefined("failure-description") ? masterResult.get("failure-description") : new ModelNode().set("Unexplained failure");
            } else {
                for (Map.Entry<String, ModelNode> entry : hostResults.entrySet()) {
                    ModelNode hostResult = entry.getValue();
                    if (!hostResult.hasDefined("outcome") || !"failed".equals(hostResult.get("outcome").asString())) continue;
                    if (hostFailureResults == null) {
                        transaction.setRollbackOnly();
                        hostFailureResults = new ModelNode();
                    }
                    ModelNode desc = hostResult.hasDefined("failure-description") ? hostResult.get("failure-description") : new ModelNode().set("Unexplained failure");
                    hostFailureResults.add(entry.getKey(), desc);
                }
            }
            if (transaction.isRollbackOnly()) {
                ModelNode failureMsg = new ModelNode();
                if (masterFailureResult != null) {
                    failureMsg.get("domain-failure-description").set(masterFailureResult);
                } else if (hostFailureResults != null) {
                    failureMsg.get("host-failure-descriptions").set(hostFailureResults);
                }
                throw new OperationFailedException(failureMsg);
            }
            Map<String, Map<ServerIdentity, ModelNode>> opsByGroup = this.getOpsByGroup(hostResults);
            ModelNode compensatingOperation = this.getCompensatingOperation(operationNode, hostResults);
            if (opsByGroup.size() == 0) {
                ModelNode singleHostResult = this.getSingleHostResult(hostResults);
                result = new DomainLevelResult(singleHostResult, compensatingOperation);
            } else {
                try {
                    rolloutPlan = this.getRolloutPlan(rolloutPlan, opsByGroup);
                }
                catch (OperationFailedException ofe) {
                    ModelNode failureMsg = new ModelNode();
                    failureMsg.get("domain-failure-description").set(ofe.getFailureDescription());
                    throw new OperationFailedException(failureMsg);
                }
                result = new DomainLevelResult(opsByGroup, compensatingOperation, rolloutPlan);
            }
            DomainLevelResult domainLevelResult = result;
            return domainLevelResult;
        }
        catch (OperationFailedException ofe) {
            transaction.setRollbackOnly();
            throw ofe;
        }
        finally {
            transaction.commit();
        }
    }

    protected Void getOperationControllerContext(Operation operation) {
        return null;
    }

    private OperationRouting determineRouting(ModelNode operation) {
        OperationRouting routing;
        PathElement first;
        String targetHost = null;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String operationName = operation.get("operation").asString();
        if (address.size() > 0 && "host".equals((first = address.getElement(0)).getKey())) {
            targetHost = first.getValue();
        }
        if (targetHost != null) {
            routing = null;
            if (this.isReadOnly(operation, address)) {
                routing = new OperationRouting(targetHost, false);
            } else if (address.size() > 1 && "server".equals((first = address.getElement(1)).getKey())) {
                routing = new OperationRouting(targetHost, false);
            }
            if (routing == null) {
                routing = "start".equals(operationName) || "stop".equals(operationName) || "restart".equals(operationName) ? new OperationRouting(targetHost, false) : new OperationRouting(targetHost, true);
            }
        } else if (this.masterDomainControllerClient != null) {
            routing = new OperationRouting();
        } else if (this.isReadOnly(operation, address)) {
            routing = new OperationRouting(this.localHostName, false);
        } else if (DEPLOYMENT_OPS.contains(operationName)) {
            routing = new OperationRouting(this.localHostName, false);
        } else if ("composite".equals(operationName)) {
            if (operation.hasDefined("steps")) {
                HashSet allHosts = new HashSet();
                boolean twoStep = false;
                for (ModelNode step : operation.get("steps").asList()) {
                    OperationRouting stepRouting = this.determineRouting(step);
                    if (stepRouting.isTwoStep()) {
                        twoStep = true;
                    }
                    allHosts.addAll(stepRouting.getHosts());
                }
                routing = allHosts.size() == 1 ? new OperationRouting((String)allHosts.iterator().next(), twoStep) : new OperationRouting(allHosts);
            } else {
                routing = new OperationRouting(this.localHostName, false);
            }
        } else {
            routing = new OperationRouting(this.hosts.keySet());
        }
        return routing;
    }

    private boolean isReadOnly(ModelNode operation, PathAddress address) {
        String opName = operation.require("operation").asString();
        boolean ro = READ_ONLY_OPERATIONS.contains(opName);
        if (!ro && address.size() == 1 && "describe".equals(opName) && "profile".equals(address.getElement(0).getKey())) {
            ro = true;
        }
        return ro;
    }

    @Override
    public ModelNode getDomainAndHostModel() {
        return ((DomainModelImpl)this.localDomainModel).getDomainAndHostModel();
    }

    @Override
    public ModelNode getDomainModel() {
        return this.localDomainModel.getDomainModel();
    }

    @Override
    public FileRepository getFileRepository() {
        return this.fileRepository;
    }

    @Override
    public void setInitialDomainModel(ModelNode initialModel) {
        if (this.masterDomainControllerClient == null) {
            throw new IllegalStateException("Cannot set initial domain model on non-slave DomainController");
        }
        ((DomainModelImpl)this.localDomainModel).setInitialDomainModel(initialModel);
    }

    private Map<String, ModelNode> pushToHosts(Operation operation, OperationRouting routing, ControllerTransaction transaction) throws Exception {
        HashMap<String, ModelNode> hostResults = new HashMap<String, ModelNode>();
        HashMap<String, Future<ModelNode>> futures = new HashMap<String, Future<ModelNode>>();
        ModelNode opNode = operation.getOperation();
        Set targets = routing.getHosts();
        if (targets.remove(this.localHostName)) {
            if (this.deploymentRepository != null) {
                this.storeDeploymentContent(operation, opNode);
            }
            Operation localOperation = operation;
            if (targets.size() > 0) {
                localOperation = localOperation.clone(localOperation.getOperation().clone());
            }
            this.pushToHost(localOperation, transaction, this.localHostName, futures);
            this.processHostFuture(this.localHostName, (Future)futures.remove(this.localHostName), hostResults);
            ModelNode modelNode = (ModelNode)hostResults.get(this.localHostName);
            if (!transaction.isRollbackOnly() && modelNode.hasDefined("outcome") && "failed".equals(modelNode.get("outcome").asString())) {
                transaction.setRollbackOnly();
            }
        }
        if (!transaction.isRollbackOnly()) {
            operation = OperationBuilder.Factory.create((ModelNode)opNode).build();
            for (String string : targets) {
                this.pushToHost(operation, transaction, string, futures);
            }
            log.debugf("Domain updates pushed to %s host controller(s)", (Object)futures.size());
            for (Map.Entry entry : futures.entrySet()) {
                String host = (String)entry.getKey();
                Future future = (Future)entry.getValue();
                this.processHostFuture(host, future, hostResults);
            }
        }
        return hostResults;
    }

    private void storeDeploymentContent(Operation operation, ModelNode opNode) throws Exception {
        PathAddress address = PathAddress.pathAddress((ModelNode)opNode.get("address"));
        if (address.size() == 0) {
            String opName = opNode.get("operation").asString();
            if ("full-replace-deployment".equals(opName) && opNode.hasDefined("input-stream-index")) {
                byte[] hash = DeploymentUploadUtil.storeDeploymentContent((OperationAttachments)operation, opNode, this.deploymentRepository);
                opNode.remove("input-stream-index");
                opNode.get("hash").set(hash);
            } else if ("composite".equals(opName) && opNode.hasDefined("steps")) {
                for (ModelNode childOp : opNode.get("steps").asList()) {
                    this.storeDeploymentContent(operation, childOp);
                }
            }
        } else if (address.size() == 1 && "deployment".equals(address.getElement(0).getKey()) && "add".equals(opNode.get("operation").asString()) && opNode.hasDefined("input-stream-index")) {
            byte[] hash = DeploymentUploadUtil.storeDeploymentContent((OperationAttachments)operation, opNode, this.deploymentRepository);
            opNode.remove("input-stream-index");
            opNode.get("hash").set(hash);
        }
    }

    private void processHostFuture(String host, Future<ModelNode> future, Map<String, ModelNode> hostResults) {
        try {
            hostResults.put(host, future.get());
        }
        catch (InterruptedException e) {
            log.debug((Object)"Interrupted reading host controller response");
            Thread.currentThread().interrupt();
            hostResults.put(host, this.getDomainFailureResult(e));
        }
        catch (ExecutionException e) {
            log.info((Object)"Execution exception reading host controller response", (Throwable)e);
            hostResults.put(host, this.getDomainFailureResult(e.getCause()));
        }
    }

    private void pushToHost(final Operation operation, final ControllerTransaction transaction, final String host, Map<String, Future<ModelNode>> futures) {
        if (this.hosts.containsKey(host)) {
            Callable<ModelNode> callable = new Callable<ModelNode>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ModelNode call() throws Exception {
                    ModelNode node;
                    ModelNode modelNode = node = DomainControllerImpl.this.executeOnHost(host, operation, (ControllerTransactionContext)transaction);
                    return modelNode;
                }
            };
            futures.put(host, this.scheduledExecutorService.submit(callable));
        }
    }

    private ModelNode getDomainFailureResult(Throwable e) {
        ModelNode node = new ModelNode();
        node.get("outcome").set("failed");
        node.get("failure-description").set(this.getFailureResult(e));
        return node;
    }

    private Map<String, Map<ServerIdentity, ModelNode>> getOpsByGroup(Map<String, ModelNode> hostResults) {
        HashMap<String, Map<ServerIdentity, ModelNode>> result = new HashMap<String, Map<ServerIdentity, ModelNode>>();
        for (Map.Entry<String, ModelNode> entry : hostResults.entrySet()) {
            ModelNode hostResult = entry.getValue().get("result");
            if (!hostResult.hasDefined("server-operations")) continue;
            String host = entry.getKey();
            for (ModelNode item : hostResult.get("server-operations").asList()) {
                ModelNode op = item.require("operation");
                for (Property prop : item.require("servers").asPropertyList()) {
                    String group = prop.getValue().asString();
                    HashMap<ServerIdentity, ModelNode> groupMap = (HashMap<ServerIdentity, ModelNode>)result.get(group);
                    if (groupMap == null) {
                        groupMap = new HashMap<ServerIdentity, ModelNode>();
                        result.put(group, groupMap);
                    }
                    groupMap.put(new ServerIdentity(host, group, prop.getName()), op);
                }
            }
        }
        return result;
    }

    private ModelNode getSingleHostResult(Map<String, ModelNode> hostResults) {
        ModelNode singleHost = hostResults.get(this.localHostName);
        if (singleHost != null && (!singleHost.hasDefined("outcome") || "ignored".equals(singleHost.get("outcome").asString()))) {
            singleHost = null;
        }
        if (singleHost == null) {
            for (ModelNode node : hostResults.values()) {
                if (!node.hasDefined("outcome") || "ignored".equals(node.get("outcome").asString())) continue;
                singleHost = node;
                break;
            }
        }
        return singleHost == null ? new ModelNode() : singleHost.get("result");
    }

    private ModelNode getRolloutPlan(ModelNode rolloutPlan, Map<String, Map<ServerIdentity, ModelNode>> opsByGroup) throws OperationFailedException {
        if (rolloutPlan == null || !rolloutPlan.isDefined()) {
            rolloutPlan = this.getDefaultRolloutPlan(opsByGroup);
        } else {
            HashSet<String> found = new HashSet<String>();
            if (rolloutPlan.hasDefined("in-series")) {
                for (ModelNode series : rolloutPlan.get("in-series").asList()) {
                    if (series.hasDefined("concurrent-groups")) {
                        for (Property prop : series.get("concurrent-groups").asPropertyList()) {
                            this.validateServerGroupPlan(found, prop);
                        }
                        continue;
                    }
                    if (series.hasDefined("server-group")) {
                        Property prop = series.get("server-group").asProperty();
                        this.validateServerGroupPlan(found, prop);
                        continue;
                    }
                    throw new OperationFailedException(new ModelNode().set(String.format("Invalid rollout plan. %s is not a valid child of node %s", series, "in-series")));
                }
            }
            HashSet<String> groups = new HashSet<String>(opsByGroup.keySet());
            groups.removeAll(found);
            if (!groups.isEmpty()) {
                throw new OperationFailedException(new ModelNode().set(String.format("Invalid rollout plan. Plan operations affect server groups %s that are not reflected in the rollout plan", groups)));
            }
        }
        return rolloutPlan;
    }

    private void validateServerGroupPlan(Set<String> found, Property prop) throws OperationFailedException {
        int max;
        if (!found.add(prop.getName())) {
            throw new OperationFailedException(new ModelNode().set(String.format("Invalid rollout plan. Server group %s appears more than once in the plan.", prop.getName())));
        }
        ModelNode plan = prop.getValue();
        if (plan.hasDefined("max-failure-percentage")) {
            if (plan.has("max-failed-servers")) {
                plan.remove("max-failed-servers");
            }
            if ((max = plan.get("max-failure-percentage").asInt()) < 0 || max > 100) {
                throw new OperationFailedException(new ModelNode().set(String.format("Invalid rollout plan. Server group %s has a %s value of %s; must be between 0 and 100.", prop.getName(), "max-failure-percentage", max)));
            }
        }
        if (plan.hasDefined("max-failed-servers") && (max = plan.get("max-failed-servers").asInt()) < 0) {
            throw new OperationFailedException(new ModelNode().set(String.format("Invalid rollout plan. Server group %s has a %s value of %s; cannot be less than 0.", prop.getName(), "max-failed-servers", max)));
        }
    }

    private ModelNode getDefaultRolloutPlan(Map<String, Map<ServerIdentity, ModelNode>> opsByGroup) {
        ModelNode result = new ModelNode();
        if (opsByGroup.size() > 0) {
            ModelNode groups = result.get("in-series").add().get("concurrent-groups");
            ModelNode groupPlan = new ModelNode();
            groupPlan.get("rolling-to-servers").set(false);
            groupPlan.get("max-failed-servers").set(0);
            for (String group : opsByGroup.keySet()) {
                groups.add(group, groupPlan);
            }
            result.get("rollback-across-groups").set(true);
        }
        return result;
    }

    private ModelNode getCompensatingOperation(ModelNode operation, Map<String, ModelNode> hostResults) {
        ModelNode result;
        block10: {
            block9: {
                result = null;
                if (!this.isMultistepOperation(operation)) break block9;
                int stepCount = operation.get("steps").asInt();
                HashMap<String, ModelNode> compSteps = new HashMap<String, ModelNode>();
                ModelNode masterResult = hostResults.get(this.localHostName);
                if (masterResult != null && !"ignored".equals(masterResult.get("outcome").asString()) && masterResult.hasDefined("compensating-operation")) {
                    for (Property prop : masterResult.get("compensating-operation").asPropertyList()) {
                        ModelNode value = prop.getValue();
                        if (value.getType() != ModelType.OBJECT) continue;
                        compSteps.put(prop.getName(), value);
                    }
                }
                if (compSteps.size() < stepCount) {
                    for (ModelNode hostResult : hostResults.values()) {
                        if (hostResult == null || "ignored".equals(hostResult.get("outcome").asString()) || !hostResult.hasDefined("compensating-operation")) continue;
                        for (Property prop : masterResult.get("compensating-operation").asPropertyList()) {
                            ModelNode value;
                            if (compSteps.containsKey(prop.getName()) || (value = prop.getValue()).getType() != ModelType.OBJECT) continue;
                            compSteps.put(prop.getName(), value);
                        }
                    }
                }
                result = new ModelNode();
                for (int i = 1; i <= stepCount; ++i) {
                    String step = "step-" + i;
                    ModelNode stepComp = (ModelNode)compSteps.get(step);
                    if (stepComp == null || !stepComp.isDefined()) continue;
                    result.get("steps").add(stepComp);
                }
                if (!result.isDefined()) break block10;
                result.get("operation").set("composite");
                break block10;
            }
            ModelNode masterResult = hostResults.get(this.localHostName);
            if (masterResult != null && !"ignored".equals(masterResult.get("outcome").asString())) {
                result = masterResult.get("compensating-operation");
            }
            if (result == null) {
                for (ModelNode hostResult : hostResults.values()) {
                    if (hostResult == null || "ignored".equals(hostResult.get("outcome").asString())) continue;
                    result = hostResult.get("compensating-operation");
                    break;
                }
            }
        }
        return result;
    }

    private boolean isMultistepOperation(ModelNode operation) {
        return "composite".equals(operation.require("operation").asString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelNode executeOnHost(String hostName, Operation operation, ControllerTransactionContext tx) {
        DomainControllerSlaveClient client = this.hosts.get(hostName);
        if (client == null) {
            return null;
        }
        if (hostName.equals(this.localHostName)) {
            return tx == null ? client.execute(operation) : client.execute(operation, tx);
        }
        DomainControllerSlaveClient domainControllerSlaveClient = client;
        synchronized (domainControllerSlaveClient) {
            return tx == null ? client.execute(operation) : client.execute(operation, tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult executeOnHost(String hostName, Operation operation, ResultHandler handler) {
        DomainControllerSlaveClient client = this.hosts.get(hostName);
        if (client == null) {
            handler.handleFailed(new ModelNode().set("No host called " + hostName + " exists"));
            return new BasicOperationResult();
        }
        if (hostName.equals(this.localHostName)) {
            return client.execute(operation, handler);
        }
        DomainControllerSlaveClient domainControllerSlaveClient = client;
        synchronized (domainControllerSlaveClient) {
            return client.execute(operation, handler);
        }
    }

    static {
        HashSet<String> roops = new HashSet<String>();
        roops.add("read-attribute");
        roops.add("read-children-names");
        roops.add("read-operation-description");
        roops.add("read-operation-names");
        roops.add("read-resource-description");
        roops.add("read-resource");
        roops.add("read-children-types");
        roops.add("read-children-resources");
        roops.add("read-config-as-xml");
        READ_ONLY_OPERATIONS = Collections.unmodifiableSet(roops);
        HashSet<String> deploymentOps = new HashSet<String>();
        deploymentOps.add("upload-deployment-bytes");
        deploymentOps.add("upload-deployment-stream");
        deploymentOps.add("upload-deployment-url");
        DEPLOYMENT_OPS = Collections.unmodifiableSet(deploymentOps);
    }

    private class LocalDomainModelAdapter
    implements DomainControllerSlaveClient {
        private LocalDomainModelAdapter() {
        }

        public OperationResult execute(Operation operation, ResultHandler handler) {
            return DomainControllerImpl.this.localDomainModel.execute(operation, handler);
        }

        public ModelNode execute(Operation operation) throws CancellationException {
            return DomainControllerImpl.this.localDomainModel.execute(operation);
        }

        public ModelNode execute(Operation operation, ControllerTransactionContext transaction) {
            return DomainControllerImpl.this.localDomainModel.executeForDomain(operation, transaction);
        }

        public OperationResult execute(Operation operation, ResultHandler handler, ControllerTransactionContext transaction) {
            throw new UnsupportedOperationException("Transactional operations with a passed in ResultHandler are not supported");
        }

        @Override
        public String getId() {
            return DomainControllerImpl.this.localHostName;
        }

        @Override
        public boolean isActive() {
            return true;
        }
    }

    private class DomainLevelResult {
        private final ModelNode compensatingOperation;
        private final ModelNode rolloutPlan;
        private final Map<String, Map<ServerIdentity, ModelNode>> opsByGroup;
        private final ModelNode singleHostResult;

        private DomainLevelResult(ModelNode singleHostResult, ModelNode compensatingOperation) {
            this.singleHostResult = singleHostResult;
            this.compensatingOperation = compensatingOperation;
            this.rolloutPlan = null;
            this.opsByGroup = null;
        }

        private DomainLevelResult(Map<String, Map<ServerIdentity, ModelNode>> opsByGroup, ModelNode compensatingOperation, ModelNode rolloutPlan) {
            this.opsByGroup = opsByGroup;
            this.compensatingOperation = compensatingOperation;
            this.rolloutPlan = rolloutPlan;
            this.singleHostResult = null;
        }
    }

    private class OperationRouting {
        private final Set<String> hosts = new HashSet<String>();
        private final boolean twoStep;
        private final boolean routeToMaster;

        private OperationRouting() {
            this.twoStep = false;
            this.routeToMaster = true;
        }

        private OperationRouting(String host, boolean twoStep) {
            this.hosts.add(host);
            this.twoStep = twoStep;
            this.routeToMaster = false;
        }

        private OperationRouting(Collection<String> hosts) {
            this.hosts.addAll(hosts);
            this.twoStep = true;
            this.routeToMaster = false;
        }

        private Set<String> getHosts() {
            return this.hosts;
        }

        private String getSingleHost() {
            return this.hosts.size() == 1 ? this.hosts.iterator().next() : null;
        }

        private boolean isTwoStep() {
            return this.twoStep;
        }

        private boolean isRouteToMaster() {
            return this.routeToMaster;
        }

        private boolean isLocalOnly() {
            return DomainControllerImpl.this.localHostName.equals(this.getSingleHost());
        }
    }
}

