/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.mgmt;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.domain.controller.mgmt.RemoteDomainControllerClient;
import org.jboss.as.model.DeploymentUnitElement;
import org.jboss.as.protocol.Connection;
import org.jboss.as.protocol.ProtocolUtils;
import org.jboss.as.protocol.SimpleByteDataInput;
import org.jboss.as.protocol.SimpleByteDataOutput;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.protocol.mgmt.ManagementResponse;
import org.jboss.logging.Logger;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class DomainControllerOperationHandler
extends AbstractMessageHandler
implements ManagementOperationHandler,
Service<DomainControllerOperationHandler> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.management");
    public static final ServiceName SERVICE_NAME = DomainController.SERVICE_NAME.append(new String[]{"operation", "handler"});
    private final InjectedValue<DomainController> domainControllerValue = new InjectedValue();
    private final InjectedValue<ScheduledExecutorService> executorServiceValue = new InjectedValue();
    private final InjectedValue<ThreadFactory> threadFactoryValue = new InjectedValue();
    private final InjectedValue<FileRepository> localFileRepositoryValue = new InjectedValue();
    private DomainController domainController;
    private ScheduledExecutorService executorService;
    private ThreadFactory threadFactory;
    private FileRepository localFileRepository;

    public final byte getIdentifier() {
        return 8;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            this.domainController = (DomainController)this.domainControllerValue.getValue();
            this.executorService = (ScheduledExecutorService)this.executorServiceValue.getValue();
            this.localFileRepository = (FileRepository)this.localFileRepositoryValue.getValue();
            this.threadFactory = (ThreadFactory)this.threadFactoryValue.getValue();
        }
        catch (IllegalStateException e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        this.domainController = null;
        this.executorService = null;
        this.localFileRepository = null;
    }

    public synchronized DomainControllerOperationHandler getValue() throws IllegalStateException {
        return this;
    }

    public Injector<DomainController> getDomainControllerInjector() {
        return this.domainControllerValue;
    }

    public Injector<ScheduledExecutorService> getExecutorServiceInjector() {
        return this.executorServiceValue;
    }

    public Injector<FileRepository> getLocalFileRepositoryInjector() {
        return this.localFileRepositoryValue;
    }

    public Injector<ThreadFactory> getThreadFactoryInjector() {
        return this.threadFactoryValue;
    }

    public void handle(Connection connection, InputStream input) throws IOException {
        ProtocolUtils.expectHeader((InputStream)input, (int)2);
        byte commandCode = StreamUtils.readByte((InputStream)input);
        AbstractMessageHandler operation = this.operationFor(commandCode);
        if (operation == null) {
            throw new IOException("Invalid command code " + commandCode + " received from server manager");
        }
        log.debugf("Received DomainController operation [%s]", (Object)operation);
        operation.handle(connection, input);
    }

    private AbstractMessageHandler operationFor(byte commandByte) {
        switch (commandByte) {
            case 18: {
                return new RegisterOperation();
            }
            case 23: {
                return new GetFileOperation();
            }
            case 21: {
                return new UnregisterOperation();
            }
        }
        return null;
    }

    private static Marshaller getMarshaller() throws IOException {
        return ProtocolUtils.getMarshaller((MarshallingConfiguration)ProtocolUtils.MODULAR_CONFIG);
    }

    static /* synthetic */ FileRepository access$900(DomainControllerOperationHandler x0) {
        return x0.localFileRepository;
    }

    private class GetFileOperation
    extends DomainControllerOperation {
        private File localPath;

        private GetFileOperation() {
        }

        protected final byte getResponseCode() {
            return 39;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        protected final void readRequest(String serverManagerId, InputStream inputStream) throws IOException {
            input = null;
            try {
                input = new SimpleByteDataInput(inputStream);
                ProtocolUtils.expectHeader((DataInput)input, (int)24);
                rootId = input.readByte();
                ProtocolUtils.expectHeader((DataInput)input, (int)34);
                filePath = input.readUTF();
                DomainControllerOperationHandler.access$700().debugf("Server manager [%s] requested file [%s] from root [%d]", (Object)serverManagerId, (Object)filePath, (Object)rootId);
                switch (rootId) {
                    case 25: {
                        this.localPath = DomainControllerOperationHandler.access$900(DomainControllerOperationHandler.this).getFile(filePath);
                        ** break;
                    }
                    case 32: {
                        this.localPath = DomainControllerOperationHandler.access$900(DomainControllerOperationHandler.this).getConfigurationFile(filePath);
                        ** break;
                    }
                    case 33: {
                        hash = DeploymentUnitElement.hexStringToBytes((String)filePath);
                        this.localPath = DomainControllerOperationHandler.access$900(DomainControllerOperationHandler.this).getDeploymentRoot(hash);
                        ** break;
                    }
                    default: {
                        throw new IOException(String.format("Invalid root id [%d]", new Object[]{rootId}));
lbl22:
                        // 3 sources

                    }
                }
            }
            catch (Throwable var7_7) {
                StreamUtils.safeClose(input);
                throw var7_7;
            }
            StreamUtils.safeClose((Closeable)input);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendResponse(OutputStream outputStream) throws IOException {
            SimpleByteDataOutput output = null;
            try {
                output = new SimpleByteDataOutput(outputStream);
                output.writeByte(35);
                if (this.localPath == null || !this.localPath.exists()) {
                    output.writeInt(-1);
                } else if (this.localPath.isFile()) {
                    output.writeInt(1);
                    this.writeFile(this.localPath, (DataOutput)output);
                } else {
                    List<File> childFiles = this.getChildFiles(this.localPath);
                    output.writeInt(childFiles.size());
                    for (File child : childFiles) {
                        this.writeFile(child, (DataOutput)output);
                    }
                }
                output.close();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(output);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)output);
        }

        private List<File> getChildFiles(File base) {
            ArrayList<File> childFiles = new ArrayList<File>();
            this.getChildFiles(base, childFiles);
            return childFiles;
        }

        private void getChildFiles(File base, List<File> childFiles) {
            for (File child : base.listFiles()) {
                if (child.isFile()) {
                    childFiles.add(child);
                    continue;
                }
                this.getChildFiles(child, childFiles);
            }
        }

        private String getRelativePath(File parent, File child) {
            return child.getAbsolutePath().substring(parent.getAbsolutePath().length());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeFile(File file, DataOutput output) throws IOException {
            output.writeByte(37);
            output.writeByte(34);
            output.writeUTF(this.getRelativePath(this.localPath, file));
            output.writeByte(36);
            output.writeLong(file.length());
            FileInputStream inputStream = null;
            try {
                int len;
                inputStream = new FileInputStream(file);
                byte[] buffer = new byte[8192];
                while ((len = ((InputStream)inputStream).read(buffer)) != -1) {
                    output.write(buffer, 0, len);
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException ignored) {}
                }
            }
            output.writeByte(38);
            log.infof("Wrote file [%s]", (Object)file);
        }
    }

    private class UnregisterOperation
    extends DomainControllerOperation {
        private UnregisterOperation() {
        }

        protected final byte getResponseCode() {
            return 22;
        }

        @Override
        protected final void readRequest(String serverManagerId, InputStream input) throws IOException {
            log.infof("Server manager unregistered [%s]", (Object)serverManagerId);
            DomainControllerOperationHandler.this.domainController.removeClient(serverManagerId);
        }
    }

    private class RegisterOperation
    extends DomainControllerOperation {
        private RegisterOperation() {
        }

        protected final byte getResponseCode() {
            return 20;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void readRequest(String serverManagerId, InputStream inputStream) throws IOException {
            SimpleByteDataInput input = null;
            try {
                input = new SimpleByteDataInput(inputStream);
                ProtocolUtils.expectHeader((DataInput)input, (int)16);
                int addressSize = input.readInt();
                byte[] addressBytes = new byte[addressSize];
                input.readFully(addressBytes);
                ProtocolUtils.expectHeader((DataInput)input, (int)17);
                int port = input.readInt();
                InetAddress address = InetAddress.getByAddress(addressBytes);
                RemoteDomainControllerClient client = new RemoteDomainControllerClient(serverManagerId, address, port, DomainControllerOperationHandler.this.executorService, DomainControllerOperationHandler.this.threadFactory);
                DomainControllerOperationHandler.this.domainController.addClient(client);
                log.infof("Server manager registered [%s]", (Object)client);
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(input);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)input);
        }

        protected final void sendResponse(OutputStream output) throws IOException {
            Marshaller marshaller = DomainControllerOperationHandler.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(19);
            marshaller.writeObject((Object)DomainControllerOperationHandler.this.domainController.getDomainModel());
            marshaller.finish();
        }
    }

    private abstract class DomainControllerOperation
    extends ManagementResponse {
        private DomainControllerOperation() {
        }

        protected void readRequest(InputStream input) throws IOException {
            super.readRequest(input);
            ProtocolUtils.expectHeader((InputStream)input, (int)9);
            String serverManagerId = StreamUtils.readUTFZBytes((InputStream)input);
            this.readRequest(serverManagerId, input);
        }

        protected abstract void readRequest(String var1, InputStream var2) throws IOException;
    }
}

