/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.mgmt;

import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.jboss.as.domain.client.api.DomainUpdateResult;
import org.jboss.as.domain.client.api.HostUpdateResult;
import org.jboss.as.domain.client.api.ServerIdentity;
import org.jboss.as.domain.client.api.ServerStatus;
import org.jboss.as.domain.client.api.deployment.DeploymentPlan;
import org.jboss.as.domain.client.impl.DomainUpdateApplierResponse;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.StreamedResponse;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateResultHandlerResponse;
import org.jboss.as.protocol.Connection;
import org.jboss.as.protocol.ProtocolUtils;
import org.jboss.as.protocol.SimpleByteDataInput;
import org.jboss.as.protocol.SimpleByteDataOutput;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.protocol.mgmt.ManagementResponse;
import org.jboss.logging.Logger;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.SimpleClassResolver;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class DomainControllerClientOperationHandler
extends AbstractMessageHandler
implements ManagementOperationHandler,
Service<DomainControllerClientOperationHandler> {
    private static final MarshallingConfiguration CONFIG = new MarshallingConfiguration();
    private static final Logger log;
    public static final ServiceName SERVICE_NAME;
    private final InjectedValue<DomainController> domainControllerValue = new InjectedValue();
    private DomainController domainController;

    public final byte getIdentifier() {
        return 10;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            this.domainController = (DomainController)this.domainControllerValue.getValue();
        }
        catch (IllegalStateException e) {
            throw new StartException(String.format("%S not injected", DomainController.class.getSimpleName()), (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        this.domainController = null;
    }

    public synchronized DomainControllerClientOperationHandler getValue() throws IllegalStateException {
        return this;
    }

    public Injector<DomainController> getDomainControllerInjector() {
        return this.domainControllerValue;
    }

    public void handle(Connection connection, InputStream input) throws IOException {
        ProtocolUtils.expectHeader((InputStream)input, (int)2);
        byte commandCode = StreamUtils.readByte((InputStream)input);
        AbstractMessageHandler operation = this.operationFor(commandCode);
        if (operation == null) {
            throw new IOException("Invalid command code " + commandCode + " received from server manager");
        }
        log.debugf("Received DomainClient operation [%s]", (Object)operation);
        operation.handle(connection, input);
    }

    private AbstractMessageHandler operationFor(byte commandByte) {
        switch (commandByte) {
            case 21: {
                return new GetDomainOperation();
            }
            case 23: {
                return new ApplyDomainModelUpdatesOperation();
            }
            case 34: {
                return new ApplyUpdateToDomainModelUpdateOperation();
            }
            case 65: {
                return new ExecuteDeploymentPlanOperation();
            }
            case 56: {
                return new CheckUniqueDeploymentNameOperation();
            }
            case 49: {
                return new AddDeploymentContentOperation();
            }
            case 36: {
                return new ApplyServerModelUpdateOperation();
            }
            case 88: {
                return new ApplyHostModelUpdatesOperation();
            }
            case 98: {
                return new GetHostModelOperation();
            }
            case 101: {
                return new GetServerManagerNamesOperation();
            }
            case 113: {
                return new GetServerStatusesOperation();
            }
            case 104: {
                return new GetServerModelOperation();
            }
            case 117: {
                return new StartServerOperation();
            }
            case 119: {
                return new StopServerOperation();
            }
            case 122: {
                return new RestartServerOperation();
            }
        }
        return null;
    }

    private static Marshaller getMarshaller() throws IOException {
        return ProtocolUtils.getMarshaller((MarshallingConfiguration)CONFIG);
    }

    private static Unmarshaller getUnmarshaller() throws IOException {
        return ProtocolUtils.getUnmarshaller((MarshallingConfiguration)CONFIG);
    }

    static {
        try {
            ModuleClassLoader cl = Module.getModuleFromDefaultLoader((ModuleIdentifier)ModuleIdentifier.create((String)"org.jboss.as.aggregate")).getClassLoader();
            CONFIG.setClassResolver((ClassResolver)new SimpleClassResolver((ClassLoader)cl));
        }
        catch (ModuleLoadException e) {
            throw new RuntimeException(e);
        }
        log = Logger.getLogger((String)"org.jboss.as.management");
        SERVICE_NAME = DomainController.SERVICE_NAME.append(new String[]{"client", "operation", "handler"});
    }

    private class AddDeploymentContentOperation
    extends ManagementResponse {
        private byte[] deploymentHash;

        private AddDeploymentContentOperation() {
        }

        protected final byte getResponseCode() {
            return 55;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void readRequest(InputStream inputStream) throws IOException {
            SimpleByteDataInput input = null;
            try {
                input = new SimpleByteDataInput(inputStream);
                ProtocolUtils.expectHeader((DataInput)input, (int)50);
                String deploymentName = input.readUTF();
                ProtocolUtils.expectHeader((DataInput)input, (int)51);
                String deploymentRuntimeName = input.readUTF();
                ProtocolUtils.expectHeader((DataInput)input, (int)52);
                this.deploymentHash = DomainControllerClientOperationHandler.this.domainController.getDomainDeploymentRepository().addDeploymentContent(deploymentName, deploymentRuntimeName, (InputStream)input);
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(input);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)input);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendResponse(OutputStream outputStream) throws IOException {
            SimpleByteDataOutput output = null;
            try {
                output = new SimpleByteDataOutput(outputStream);
                output.writeByte(53);
                output.writeInt(this.deploymentHash.length);
                output.writeByte(54);
                output.write(this.deploymentHash);
                output.close();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(output);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)output);
        }
    }

    private class CheckUniqueDeploymentNameOperation
    extends ManagementResponse {
        private String deploymentName;

        private CheckUniqueDeploymentNameOperation() {
        }

        protected final byte getResponseCode() {
            return 64;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void readRequest(InputStream inputStream) throws IOException {
            SimpleByteDataInput input = null;
            try {
                input = new SimpleByteDataInput(inputStream);
                ProtocolUtils.expectHeader((DataInput)input, (int)50);
                this.deploymentName = input.readUTF();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(input);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)input);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendResponse(OutputStream outputStream) throws IOException {
            SimpleByteDataOutput output = null;
            try {
                output = new SimpleByteDataOutput(outputStream);
                output.writeByte(57);
                output.writeBoolean(DomainControllerClientOperationHandler.this.domainController.isDeploymentNameUnique(this.deploymentName));
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(output);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)output);
        }
    }

    private class ExecuteDeploymentPlanOperation
    extends ManagementResponse {
        private DeploymentPlan deploymentPlan;

        private ExecuteDeploymentPlanOperation() {
        }

        protected final byte getResponseCode() {
            return 87;
        }

        protected final void readRequest(InputStream input) throws IOException {
            Unmarshaller unmarshaller = DomainControllerClientOperationHandler.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)66);
            this.deploymentPlan = (DeploymentPlan)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, DeploymentPlan.class);
            unmarshaller.finish();
        }

        protected void sendResponse(OutputStream output) throws IOException {
            StreamedResponse rsp;
            Marshaller marshaller = DomainControllerClientOperationHandler.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            LinkedBlockingQueue<List<StreamedResponse>> responseQueue = new LinkedBlockingQueue<List<StreamedResponse>>();
            DomainControllerClientOperationHandler.this.domainController.executeDeploymentPlan(this.deploymentPlan, responseQueue);
            do {
                List rspList;
                rsp = null;
                try {
                    rspList = (List)responseQueue.take();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted while reading deployment plan execution responses", ie);
                }
                Iterator i$ = rspList.iterator();
                while (i$.hasNext()) {
                    StreamedResponse item;
                    rsp = item = (StreamedResponse)i$.next();
                    marshaller.writeByte((int)rsp.getProtocolValue());
                    log.tracef("Marshalling StreamedResponse %s", (Object)rsp.getProtocolValue());
                    if (rsp.getValue() == null) continue;
                    marshaller.writeObject(rsp.getValue());
                }
            } while (rsp != null && !rsp.isLastInStream());
            marshaller.finish();
        }
    }

    private class ApplyServerModelUpdateOperation
    extends ManagementResponse {
        private AbstractServerModelUpdate<?> update;
        private ServerIdentity server;

        private ApplyServerModelUpdateOperation() {
        }

        protected final byte getResponseCode() {
            return 48;
        }

        protected final void readRequest(InputStream input) throws IOException {
            Unmarshaller unmarshaller = DomainControllerClientOperationHandler.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)37);
            String hostName = unmarshaller.readUTF();
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)38);
            String serverGroupName = unmarshaller.readUTF();
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)39);
            String serverName = unmarshaller.readUTF();
            this.server = new ServerIdentity(hostName, serverGroupName, serverName);
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)40);
            this.update = (AbstractServerModelUpdate)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, AbstractServerModelUpdate.class);
            unmarshaller.finish();
            log.infof("Received server model update %s", this.update);
        }

        protected void sendResponse(OutputStream output) throws IOException {
            UpdateResultHandlerResponse<?> response = this.processUpdate();
            Marshaller marshaller = DomainControllerClientOperationHandler.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(41);
            marshaller.writeObject(response);
            marshaller.finish();
        }

        private UpdateResultHandlerResponse<?> processUpdate() {
            List<UpdateResultHandlerResponse<?>> list = DomainControllerClientOperationHandler.this.domainController.applyUpdatesToServer(this.server, Collections.singletonList(this.update), false);
            return list.get(0);
        }
    }

    private class ApplyUpdateToDomainModelUpdateOperation
    extends ManagementResponse {
        private AbstractDomainModelUpdate<?> update;

        private ApplyUpdateToDomainModelUpdateOperation() {
        }

        protected final byte getResponseCode() {
            return 35;
        }

        protected final void readRequest(InputStream input) throws IOException {
            Unmarshaller unmarshaller = DomainControllerClientOperationHandler.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)20);
            this.update = (AbstractDomainModelUpdate)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, AbstractDomainModelUpdate.class);
            unmarshaller.finish();
            log.infof("Received domain model update %s", this.update);
        }

        protected void sendResponse(OutputStream output) throws IOException {
            DomainUpdateApplierResponse response = this.processUpdate();
            Marshaller marshaller = DomainControllerClientOperationHandler.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(32);
            marshaller.writeObject((Object)response);
            marshaller.finish();
        }

        private DomainUpdateApplierResponse processUpdate() {
            return DomainControllerClientOperationHandler.this.domainController.applyUpdateToModel(this.update);
        }
    }

    private class ApplyHostModelUpdatesOperation
    extends ManagementResponse {
        private String serverManagerName;
        private List<AbstractHostModelUpdate<?>> updates;

        private ApplyHostModelUpdatesOperation() {
        }

        protected final byte getResponseCode() {
            return 97;
        }

        protected final void readRequest(InputStream inputStream) throws IOException {
            Unmarshaller unmarshaller = DomainControllerClientOperationHandler.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)inputStream));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)37);
            this.serverManagerName = unmarshaller.readUTF();
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)24);
            int count = unmarshaller.readInt();
            this.updates = new ArrayList(count);
            for (int i = 0; i < count; ++i) {
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)89);
                AbstractHostModelUpdate update = (AbstractHostModelUpdate)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, AbstractHostModelUpdate.class);
                this.updates.add(update);
            }
            unmarshaller.finish();
            log.infof("Received host model updates %s", this.updates);
        }

        protected void sendResponse(OutputStream output) throws IOException {
            List<HostUpdateResult<?>> responses = DomainControllerClientOperationHandler.this.domainController.applyHostUpdates(this.serverManagerName, this.updates);
            Marshaller marshaller = DomainControllerClientOperationHandler.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(25);
            marshaller.writeInt(responses.size());
            for (HostUpdateResult<?> response : responses) {
                marshaller.writeByte(96);
                marshaller.writeObject(response);
            }
            marshaller.finish();
        }
    }

    private class ApplyDomainModelUpdatesOperation
    extends ManagementResponse {
        private List<AbstractDomainModelUpdate<?>> updates;

        private ApplyDomainModelUpdatesOperation() {
        }

        protected final byte getResponseCode() {
            return 33;
        }

        protected final void readRequest(InputStream inputStream) throws IOException {
            Unmarshaller unmarshaller = DomainControllerClientOperationHandler.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)inputStream));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)24);
            int count = unmarshaller.readInt();
            this.updates = new ArrayList(count);
            for (int i = 0; i < count; ++i) {
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)20);
                AbstractDomainModelUpdate update = (AbstractDomainModelUpdate)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, AbstractDomainModelUpdate.class);
                this.updates.add(update);
            }
            unmarshaller.finish();
            log.infof("Received domain model updates %s", this.updates);
        }

        protected void sendResponse(OutputStream output) throws IOException {
            List<DomainUpdateResult<?>> responses = DomainControllerClientOperationHandler.this.domainController.applyUpdates(this.updates);
            Marshaller marshaller = DomainControllerClientOperationHandler.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(25);
            marshaller.writeInt(responses.size());
            for (DomainUpdateResult<?> response : responses) {
                marshaller.writeByte(32);
                marshaller.writeObject(response);
            }
            marshaller.finish();
        }
    }

    private abstract class ServerStatusChangeOperation
    extends ManagementResponse {
        private final boolean expectTimeout;
        private String serverManagerName;
        private String serverName;
        private long gracefulTimeout;

        ServerStatusChangeOperation(boolean expectTimeout) {
            this.expectTimeout = expectTimeout;
        }

        protected abstract ServerStatus processChange(String var1, String var2, long var3);

        protected final void readRequest(InputStream inputStream) throws IOException {
            Unmarshaller unmarshaller = DomainControllerClientOperationHandler.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)inputStream));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)37);
            this.serverManagerName = unmarshaller.readUTF();
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)39);
            this.serverName = unmarshaller.readUTF();
            if (this.expectTimeout) {
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)120);
                this.gracefulTimeout = unmarshaller.readLong();
            }
            unmarshaller.finish();
        }

        protected void sendResponse(OutputStream outputStream) throws IOException {
            ServerStatus status = this.processChange(this.serverManagerName, this.serverName, this.gracefulTimeout);
            Marshaller marshaller = DomainControllerClientOperationHandler.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)outputStream));
            marshaller.writeByte(115);
            marshaller.writeObject((Object)status);
            marshaller.finish();
        }
    }

    private class StopServerOperation
    extends ServerStatusChangeOperation {
        private StopServerOperation() {
            super(true);
        }

        protected final byte getResponseCode() {
            return 121;
        }

        @Override
        protected ServerStatus processChange(String serverManagerName, String serverName, long gracefulTimeout) {
            return DomainControllerClientOperationHandler.this.domainController.stopServer(serverManagerName, serverName, gracefulTimeout);
        }
    }

    private class RestartServerOperation
    extends ServerStatusChangeOperation {
        private RestartServerOperation() {
            super(true);
        }

        protected final byte getResponseCode() {
            return 123;
        }

        @Override
        protected ServerStatus processChange(String serverManagerName, String serverName, long gracefulTimeout) {
            return DomainControllerClientOperationHandler.this.domainController.restartServer(serverManagerName, serverName, gracefulTimeout);
        }
    }

    private class StartServerOperation
    extends ServerStatusChangeOperation {
        private StartServerOperation() {
            super(false);
        }

        protected final byte getResponseCode() {
            return 118;
        }

        @Override
        protected ServerStatus processChange(String serverManagerName, String serverName, long gracefulTimeout) {
            return DomainControllerClientOperationHandler.this.domainController.startServer(serverManagerName, serverName);
        }
    }

    private class GetServerModelOperation
    extends ManagementResponse {
        private String serverManagerName;
        private String serverName;

        private GetServerModelOperation() {
        }

        protected final byte getResponseCode() {
            return 112;
        }

        protected final void readRequest(InputStream inputStream) throws IOException {
            Unmarshaller unmarshaller = DomainControllerClientOperationHandler.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)inputStream));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)37);
            this.serverManagerName = unmarshaller.readUTF();
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)39);
            this.serverName = unmarshaller.readUTF();
            unmarshaller.finish();
        }

        protected void sendResponse(OutputStream outputStream) throws IOException {
            ServerModel serverModel = DomainControllerClientOperationHandler.this.domainController.getServerModel(this.serverManagerName, this.serverName);
            Marshaller marshaller = DomainControllerClientOperationHandler.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)outputStream));
            marshaller.writeByte(105);
            marshaller.writeObject((Object)serverModel);
            marshaller.finish();
        }
    }

    private class GetServerStatusesOperation
    extends ManagementResponse {
        private GetServerStatusesOperation() {
        }

        protected final byte getResponseCode() {
            return 116;
        }

        protected void sendResponse(OutputStream outputStream) throws IOException {
            Map<ServerIdentity, ServerStatus> statuses = DomainControllerClientOperationHandler.this.domainController.getServerStatuses();
            Marshaller marshaller = DomainControllerClientOperationHandler.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)outputStream));
            marshaller.writeByte(114);
            marshaller.writeInt(statuses.size());
            for (Map.Entry<ServerIdentity, ServerStatus> entry : statuses.entrySet()) {
                ServerIdentity id = entry.getKey();
                marshaller.writeByte(73);
                marshaller.writeUTF(id.getHostName());
                marshaller.writeByte(80);
                marshaller.writeUTF(id.getServerGroupName());
                marshaller.writeByte(81);
                marshaller.writeUTF(id.getServerName());
                marshaller.writeByte(115);
                marshaller.writeObject((Object)entry.getValue());
            }
            marshaller.finish();
        }
    }

    private class GetHostModelOperation
    extends ManagementResponse {
        private String serverManagerName;

        private GetHostModelOperation() {
        }

        protected final byte getResponseCode() {
            return 100;
        }

        protected final void readRequest(InputStream inputStream) throws IOException {
            Unmarshaller unmarshaller = DomainControllerClientOperationHandler.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)inputStream));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)37);
            this.serverManagerName = unmarshaller.readUTF();
            unmarshaller.finish();
        }

        protected void sendResponse(OutputStream outputStream) throws IOException {
            Marshaller marshaller = DomainControllerClientOperationHandler.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)outputStream));
            marshaller.writeByte(99);
            marshaller.writeObject((Object)DomainControllerClientOperationHandler.this.domainController.getHostModel(this.serverManagerName));
            marshaller.finish();
        }
    }

    private class GetServerManagerNamesOperation
    extends ManagementResponse {
        private GetServerManagerNamesOperation() {
        }

        protected final byte getResponseCode() {
            return 103;
        }

        protected void sendResponse(OutputStream outputStream) throws IOException {
            Marshaller marshaller = DomainControllerClientOperationHandler.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)outputStream));
            Set<String> serverManagerNames = DomainControllerClientOperationHandler.this.domainController.getServerManagerNames();
            marshaller.writeByte(102);
            marshaller.writeInt(serverManagerNames.size());
            for (String name : serverManagerNames) {
                marshaller.writeByte(73);
                marshaller.writeUTF(name);
            }
            marshaller.finish();
        }
    }

    private class GetDomainOperation
    extends ManagementResponse {
        private GetDomainOperation() {
        }

        protected final byte getResponseCode() {
            return 22;
        }

        protected void sendResponse(OutputStream outputStream) throws IOException {
            Marshaller marshaller = DomainControllerClientOperationHandler.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)outputStream));
            marshaller.writeByte(19);
            marshaller.writeObject((Object)DomainControllerClientOperationHandler.this.domainController.getDomainModel());
            marshaller.finish();
        }
    }
}

