/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationFailedRuntimeException;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class PathAddress
implements Iterable<PathElement> {
    public static final PathAddress EMPTY_ADDRESS = new PathAddress(Collections.<PathElement>emptyList());
    private final List<PathElement> pathAddressList;

    public static PathAddress pathAddress(ModelNode node) {
        if (node.isDefined()) {
            ArrayList<Property> props = new ArrayList<Property>();
            String key = null;
            for (ModelNode element : node.asList()) {
                Property prop = null;
                if (element.getType() == ModelType.PROPERTY || element.getType() == ModelType.OBJECT) {
                    prop = element.asProperty();
                } else if (key == null) {
                    key = element.asString();
                } else {
                    prop = new Property(key, element);
                }
                if (prop == null) continue;
                props.add(prop);
                key = null;
            }
            if (props.size() == 0) {
                return EMPTY_ADDRESS;
            }
            HashSet<String> seen = new HashSet<String>();
            ArrayList<PathElement> values = new ArrayList<PathElement>();
            int index = 0;
            for (Property prop : props) {
                String name = prop.getName();
                if (!seen.add(name)) {
                    throw PathAddress.duplicateElement(name);
                }
                values.add(new PathElement(name, prop.getValue().asString()));
                if (index == 1 && name.equals("server") && seen.contains("host")) {
                    seen.clear();
                }
                ++index;
            }
            return new PathAddress(Collections.unmodifiableList(values));
        }
        return EMPTY_ADDRESS;
    }

    public static PathAddress pathAddress(List<PathElement> elements) {
        if (elements.size() == 0) {
            return EMPTY_ADDRESS;
        }
        ArrayList<PathElement> newList = new ArrayList<PathElement>(elements.size());
        HashSet<String> seen = new HashSet<String>();
        int index = 0;
        for (PathElement element : elements) {
            String name = element.getKey();
            if (!seen.add(name)) {
                throw PathAddress.duplicateElement(name);
            }
            newList.add(element);
            if (index == 1 && name.equals("server") && seen.contains("host")) {
                seen.clear();
            }
            ++index;
        }
        return new PathAddress(Collections.unmodifiableList(newList));
    }

    public static PathAddress pathAddress(PathElement ... elements) {
        return PathAddress.pathAddress(Arrays.asList(elements));
    }

    public static PathAddress pathAddress(PathAddress parent, PathElement ... elements) {
        ArrayList<PathElement> list = new ArrayList<PathElement>(parent.pathAddressList);
        for (PathElement element : elements) {
            list.add(element);
        }
        return PathAddress.pathAddress(list);
    }

    private static OperationFailedRuntimeException duplicateElement(String name) {
        return ControllerMessages.MESSAGES.duplicateElement(name);
    }

    PathAddress(List<PathElement> pathAddressList) {
        assert (pathAddressList != null) : ControllerMessages.MESSAGES.nullVar("pathAddressList").getLocalizedMessage();
        this.pathAddressList = pathAddressList;
    }

    public PathElement getElement(int index) {
        List<PathElement> list = this.pathAddressList;
        return list.get(index);
    }

    public PathElement getLastElement() {
        List<PathElement> list = this.pathAddressList;
        return list.size() == 0 ? null : list.get(list.size() - 1);
    }

    public PathAddress subAddress(int start) {
        List<PathElement> list = this.pathAddressList;
        return new PathAddress(list.subList(start, list.size()));
    }

    public PathAddress subAddress(int start, int end) {
        return new PathAddress(this.pathAddressList.subList(start, end));
    }

    public PathAddress append(List<PathElement> additionalElements) {
        ArrayList<PathElement> newList = new ArrayList<PathElement>(this.pathAddressList.size() + additionalElements.size());
        newList.addAll(this.pathAddressList);
        newList.addAll(additionalElements);
        return PathAddress.pathAddress(newList);
    }

    public PathAddress append(PathElement ... additionalElements) {
        return this.append(Arrays.asList(additionalElements));
    }

    public PathAddress append(PathAddress address) {
        return this.append(address.pathAddressList);
    }

    public PathAddress append(String key, String value) {
        return this.append(PathElement.pathElement(key, value));
    }

    public PathAddress append(String key) {
        return this.append(PathElement.pathElement(key));
    }

    public ModelNode navigate(ModelNode model, boolean create) throws NoSuchElementException {
        Iterator<PathElement> i = this.pathAddressList.iterator();
        while (i.hasNext()) {
            PathElement element = i.next();
            if (create && !i.hasNext()) {
                if (element.isMultiTarget()) {
                    throw new IllegalStateException();
                }
                model = model.require(element.getKey()).get(element.getValue());
                continue;
            }
            model = model.require(element.getKey()).require(element.getValue());
        }
        return model;
    }

    public ModelNode remove(ModelNode model) throws NoSuchElementException {
        Iterator<PathElement> i = this.pathAddressList.iterator();
        while (i.hasNext()) {
            PathElement element = i.next();
            if (i.hasNext()) {
                model = model.require(element.getKey()).require(element.getValue());
                continue;
            }
            ModelNode parent = model.require(element.getKey());
            model = parent.remove(element.getValue()).clone();
        }
        return model;
    }

    public ModelNode toModelNode() {
        ModelNode node = new ModelNode().setEmptyList();
        for (PathElement element : this.pathAddressList) {
            String value = element.isMultiTarget() && !element.isWildcard() ? '[' + element.getValue() + ']' : element.getValue();
            node.add(element.getKey(), value);
        }
        return node;
    }

    public boolean isMultiTarget() {
        for (PathElement element : this.pathAddressList) {
            if (!element.isMultiTarget()) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.pathAddressList.size();
    }

    @Override
    public ListIterator<PathElement> iterator() {
        return this.pathAddressList.listIterator();
    }

    public int hashCode() {
        return ((Object)this.pathAddressList).hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof PathAddress && this.equals((PathAddress)other);
    }

    public boolean equals(PathAddress other) {
        return this == other || other != null && ((Object)this.pathAddressList).equals(other.pathAddressList);
    }

    public String toString() {
        return this.toModelNode().toString();
    }
}

