/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.security.AccessController;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ModelController;
import org.jboss.as.protocol.mgmt.support.ManagementChannelInitialization;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.JBossThreadFactory;

public abstract class AbstractModelControllerOperationHandlerFactoryService
implements Service<AbstractModelControllerOperationHandlerFactoryService>,
ManagementChannelInitialization {
    public static final ServiceName OPERATION_HANDLER_NAME_SUFFIX = ServiceName.of((String[])new String[]{"operation", "handler"});
    private final InjectedValue<ModelController> modelControllerValue = new InjectedValue();
    private final InjectedValue<ExecutorService> executor = new InjectedValue();

    public InjectedValue<ModelController> getModelControllerInjector() {
        return this.modelControllerValue;
    }

    public InjectedValue<ExecutorService> getExecutorInjector() {
        return this.executor;
    }

    public synchronized void start(StartContext context) throws StartException {
        ControllerLogger.SERVER_MANAGEMENT_LOGGER.debugf("Starting operation handler service %s", context.getController().getName());
        if (this.executor.getOptionalValue() == null) {
            JBossThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("management-handler-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext());
            ThreadPoolExecutor executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)threadFactory);
            this.getExecutorInjector().inject((Object)executorService);
        }
    }

    public synchronized void stop(StopContext context) {
    }

    public synchronized AbstractModelControllerOperationHandlerFactoryService getValue() throws IllegalStateException {
        return this;
    }

    protected ModelController getController() {
        return (ModelController)this.modelControllerValue.getValue();
    }

    protected ExecutorService getExecutor() {
        return (ExecutorService)this.executor.getValue();
    }
}

