/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationClientException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SecurityActions;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.dmr.ModelNode;

abstract class AbstractOperationContext
implements OperationContext {
    static final ThreadLocal<Thread> controllingThread = new ThreadLocal();
    private final OperationContext.Type contextType;
    final Thread initiatingThread;
    private final EnumMap<OperationContext.Stage, Deque<Step>> steps;
    private final ModelController.OperationTransactionControl transactionControl;
    private final ControlledProcessState processState;
    private final boolean booting;
    private final ProcessType processType;
    private final RunningMode runningMode;
    boolean respectInterruption = true;
    OperationContext.Stage currentStage = OperationContext.Stage.MODEL;
    OperationContext.ResultAction resultAction;
    boolean cancelled;
    Step activeStep;

    AbstractOperationContext(ProcessType processType, RunningMode runningMode, ModelController.OperationTransactionControl transactionControl, ControlledProcessState processState, boolean booting) {
        this.processType = processType;
        this.runningMode = runningMode;
        this.contextType = OperationContext.Type.getType(processType, runningMode);
        this.transactionControl = transactionControl;
        this.processState = processState;
        this.booting = booting;
        this.steps = new EnumMap(OperationContext.Stage.class);
        for (OperationContext.Stage stage : OperationContext.Stage.values()) {
            if (booting && stage == OperationContext.Stage.VERIFY) {
                this.steps.put(stage, new LinkedBlockingDeque());
                continue;
            }
            this.steps.put(stage, new ArrayDeque());
        }
        this.initiatingThread = Thread.currentThread();
    }

    @Override
    public boolean isBooting() {
        return this.booting;
    }

    @Override
    public void addStep(OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        this.addStep(step, stage, false);
    }

    @Override
    public void addStep(ModelNode operation, OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        ModelNode response = this.activeStep == null ? new ModelNode().setEmptyObject() : this.activeStep.response;
        this.addStep(response, operation, null, step, stage);
    }

    @Override
    public void addStep(ModelNode response, ModelNode operation, OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        this.addStep(response, operation, null, step, stage);
    }

    @Override
    public void addStep(OperationStepHandler step, OperationContext.Stage stage, boolean addFirst) throws IllegalArgumentException {
        ModelNode response = this.activeStep == null ? new ModelNode().setEmptyObject() : this.activeStep.response;
        this.addStep(response, this.activeStep.operation, this.activeStep.address, step, stage, addFirst);
    }

    void addStep(ModelNode response, ModelNode operation, PathAddress address, OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        this.addStep(response, operation, address, step, stage, false);
    }

    @Override
    public void addStep(ModelNode response, ModelNode operation, OperationStepHandler step, OperationContext.Stage stage, boolean addFirst) throws IllegalArgumentException {
        this.addStep(response, operation, null, step, stage, addFirst);
    }

    void addStep(ModelNode response, ModelNode operation, PathAddress address, OperationStepHandler step, OperationContext.Stage stage, boolean addFirst) throws IllegalArgumentException {
        assert (this.isControllingThread());
        if (response == null) {
            throw ControllerMessages.MESSAGES.nullVar("response");
        }
        if (operation == null) {
            throw ControllerMessages.MESSAGES.nullVar("operation");
        }
        if (step == null) {
            throw ControllerMessages.MESSAGES.nullVar("step");
        }
        if (stage == null) {
            throw ControllerMessages.MESSAGES.nullVar("stage");
        }
        if (this.currentStage == OperationContext.Stage.DONE) {
            throw ControllerMessages.MESSAGES.operationAlreadyComplete();
        }
        if (stage.compareTo(this.currentStage) < 0 && (stage != OperationContext.Stage.IMMEDIATE || this.currentStage == OperationContext.Stage.DONE)) {
            throw ControllerMessages.MESSAGES.stageAlreadyComplete(stage);
        }
        if (stage == OperationContext.Stage.DOMAIN && this.contextType != OperationContext.Type.HOST) {
            throw ControllerMessages.MESSAGES.invalidStage(stage, this.contextType);
        }
        if (stage == OperationContext.Stage.DONE) {
            throw ControllerMessages.MESSAGES.invalidStepStage();
        }
        if (!this.booting && this.activeStep != null && this.activeStep.operation.hasDefined("operation-headers") && this.activeStep.operation.get("operation-headers").hasDefined("caller-type")) {
            operation.get(new String[]{"operation-headers", "caller-type"}).set(this.activeStep.operation.get(new String[]{"operation-headers", "caller-type"}));
        }
        if (stage == OperationContext.Stage.IMMEDIATE) {
            this.steps.get((Object)this.currentStage).addFirst(new Step(step, response, operation, address));
        } else {
            Deque<Step> deque = this.steps.get((Object)stage);
            if (addFirst) {
                deque.addFirst(new Step(step, response, operation, address));
            } else {
                deque.addLast(new Step(step, response, operation, address));
            }
        }
    }

    @Override
    public final ModelNode getFailureDescription() {
        return this.activeStep.response.get("failure-description");
    }

    @Override
    public final boolean hasFailureDescription() {
        return this.activeStep.response.has("failure-description");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final OperationContext.ResultAction completeStep() {
        try {
            this.doCompleteStep();
            if (this.resultAction == OperationContext.ResultAction.KEEP) {
                this.report(MessageSeverity.INFO, ControllerMessages.MESSAGES.operationSucceeded());
            } else {
                this.report(MessageSeverity.INFO, ControllerMessages.MESSAGES.operationRollingBack());
            }
            OperationContext.ResultAction resultAction = this.resultAction;
            return resultAction;
        }
        finally {
            this.respectInterruption = false;
        }
    }

    @Override
    public final void completeStep(OperationContext.RollbackHandler rollbackHandler) {
        if (rollbackHandler == null) {
            throw ControllerMessages.MESSAGES.nullVar("rollbackHandler");
        }
        this.activeStep.rollbackHandler = rollbackHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompleteStep() {
        ModelNode response;
        assert (this.isControllingThread());
        if (this.currentStage == null) {
            throw ControllerMessages.MESSAGES.operationAlreadyComplete();
        }
        if (!this.canContinueProcessing()) {
            this.respectInterruption = false;
            return;
        }
        ModelNode modelNode = response = this.activeStep == null ? null : this.activeStep.response;
        do {
            Step step;
            if ((step = this.steps.get((Object)this.currentStage).pollFirst()) == null) {
                if (!this.currentStage.hasNext()) continue;
                this.currentStage = this.currentStage.next();
                if (this.currentStage != OperationContext.Stage.VERIFY) continue;
                try {
                    this.awaitModelControllerContainerMonitor();
                }
                catch (InterruptedException e) {
                    this.cancelled = true;
                    if (response != null) {
                        response.get("outcome").set("cancelled");
                        response.get("failure-description").set(ControllerMessages.MESSAGES.operationCancelled());
                        response.get("rolled-back").set(true);
                    }
                    this.resultAction = OperationContext.ResultAction.ROLLBACK;
                    this.respectInterruption = false;
                    Thread.currentThread().interrupt();
                    if (this.activeStep != null && this.activeStep.rollbackHandler != null) {
                        this.activeStep.finalizeStep(null);
                    }
                    return;
                }
            } else {
                Throwable toThrow = null;
                try {
                    this.executeStep(step);
                }
                catch (RuntimeException re) {
                    toThrow = re;
                }
                catch (Error e) {
                    toThrow = e;
                }
                finally {
                    if (step.rollbackHandler == null) {
                        AbstractOperationContext.throwThrowable(toThrow);
                        return;
                    }
                    if (!this.canContinueProcessing()) {
                        this.respectInterruption = false;
                        step.finalizeStep(toThrow);
                        return;
                    }
                    AbstractOperationContext.throwThrowable(toThrow);
                    response = this.activeStep.response;
                }
            }
        } while (this.currentStage != OperationContext.Stage.DONE);
        ConfigurationPersister.PersistenceResource persistenceResource = null;
        if (this.isModelAffected() && this.resultAction != OperationContext.ResultAction.ROLLBACK) {
            try {
                persistenceResource = this.createPersistenceResource();
            }
            catch (ConfigurationPersistenceException e) {
                ControllerLogger.MGMT_OP_LOGGER.failedToPersistConfigurationChange(e);
                if (response != null) {
                    response.get("outcome").set("failed");
                    response.get("failure-description").set(ControllerMessages.MESSAGES.failedToPersistConfigurationChange(e.getLocalizedMessage()));
                }
                this.resultAction = OperationContext.ResultAction.ROLLBACK;
                return;
            }
        }
        final AtomicReference<OperationContext.ResultAction> ref = new AtomicReference<OperationContext.ResultAction>(this.transactionControl == null ? OperationContext.ResultAction.KEEP : OperationContext.ResultAction.ROLLBACK);
        if (this.transactionControl != null) {
            if (ControllerLogger.MGMT_OP_LOGGER.isTraceEnabled()) {
                ControllerLogger.MGMT_OP_LOGGER.trace("Prepared response is " + response);
            }
            this.transactionControl.operationPrepared(new ModelController.OperationTransaction(){

                @Override
                public void commit() {
                    ref.set(OperationContext.ResultAction.KEEP);
                }

                @Override
                public void rollback() {
                    ref.set(OperationContext.ResultAction.ROLLBACK);
                }
            }, response);
        }
        this.resultAction = ref.get();
        if (persistenceResource != null) {
            if (this.resultAction == OperationContext.ResultAction.ROLLBACK) {
                persistenceResource.rollback();
            } else {
                persistenceResource.commit();
            }
        }
    }

    abstract void awaitModelControllerContainerMonitor() throws InterruptedException;

    abstract ConfigurationPersister.PersistenceResource createPersistenceResource() throws ConfigurationPersistenceException;

    private boolean canContinueProcessing() {
        if (Thread.currentThread().isInterrupted()) {
            this.cancelled = true;
        }
        if (this.cancelled) {
            if (this.activeStep != null) {
                this.activeStep.response.get("outcome").set("cancelled");
                this.activeStep.response.get("failure-description").set(ControllerMessages.MESSAGES.operationCancelled());
                this.activeStep.response.get("rolled-back").set(true);
            }
            this.resultAction = OperationContext.ResultAction.ROLLBACK;
        } else if (this.activeStep != null && this.activeStep.response.hasDefined("failure-description") && (this.isRollbackOnRuntimeFailure() || this.currentStage == OperationContext.Stage.MODEL)) {
            this.activeStep.response.get("outcome").set("failed");
            this.activeStep.response.get("rolled-back").set(true);
            this.resultAction = OperationContext.ResultAction.ROLLBACK;
        }
        return this.resultAction != OperationContext.ResultAction.ROLLBACK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStep(Step step) {
        block20: {
            step.predecessor = this.activeStep;
            this.activeStep = step;
            try {
                try {
                    ClassLoader oldTccl = SecurityActions.setThreadContextClassLoader(step.handler.getClass());
                    try {
                        step.handler.execute(this, step.operation);
                    }
                    finally {
                        SecurityActions.setThreadContextClassLoader(oldTccl);
                    }
                }
                catch (Throwable t) {
                    if (!(t instanceof OperationClientException)) {
                        throw t;
                    }
                    if (this.currentStage != OperationContext.Stage.DONE) {
                        ModelNode failDesc = ((OperationClientException)OperationClientException.class.cast(t)).getFailureDescription();
                        step.response.get("failure-description").set(failDesc);
                        if (this.isBooting()) {
                            ControllerLogger.MGMT_OP_LOGGER.operationFailed(step.operation.get("operation"), step.operation.get("address"), step.response.get("failure-description"));
                        } else {
                            ControllerLogger.MGMT_OP_LOGGER.operationFailedOnClientError(step.operation.get("operation"), step.operation.get("address"), step.response.get("failure-description"));
                        }
                        this.completeStep();
                        break block20;
                    }
                    throw t;
                }
            }
            catch (Throwable t) {
                if (t instanceof StackOverflowError) {
                    ControllerLogger.MGMT_OP_LOGGER.operationFailed(t, step.operation.get("operation"), step.operation.get("address"), "jboss.boot.thread.stack.size", 0x200000);
                } else {
                    ControllerLogger.MGMT_OP_LOGGER.operationFailed(t, step.operation.get("operation"), step.operation.get("address"));
                }
                if (this.currentStage != OperationContext.Stage.DONE) {
                    if (!step.response.hasDefined("failure-description")) {
                        step.response.get("failure-description").set(ControllerMessages.MESSAGES.operationHandlerFailed(t.getLocalizedMessage()));
                    }
                    step.response.get("outcome").set("failed");
                    this.resultAction = this.getFailedResultAction(t);
                    if (this.resultAction == OperationContext.ResultAction.ROLLBACK) {
                        step.response.get("rolled-back").set(true);
                    }
                } else {
                    this.report(MessageSeverity.WARN, ControllerMessages.MESSAGES.stepHandlerFailed(step.handler));
                }
            }
            finally {
                this.finishStep(step);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishStep(Step step) {
        boolean finalize = true;
        Throwable toThrow = null;
        try {
            if (step.rollbackHandler != null) {
                if (!this.hasMoreSteps()) {
                    this.completeStep();
                } else {
                    finalize = false;
                }
            }
        }
        catch (RuntimeException re) {
            toThrow = re;
        }
        catch (Error e) {
            toThrow = e;
        }
        finally {
            if (finalize) {
                step.finalizeStep(toThrow);
            } else {
                AbstractOperationContext.throwThrowable(toThrow);
            }
        }
    }

    private static void throwThrowable(Throwable toThrow) {
        if (toThrow != null) {
            if (toThrow instanceof RuntimeException) {
                throw (RuntimeException)toThrow;
            }
            throw (Error)toThrow;
        }
    }

    private OperationContext.ResultAction getFailedResultAction(Throwable cause) {
        if (this.currentStage == OperationContext.Stage.MODEL || this.cancelled || this.isRollbackOnRuntimeFailure() || this.isRollbackOnly() || cause != null && !(cause instanceof OperationFailedException)) {
            return OperationContext.ResultAction.ROLLBACK;
        }
        return OperationContext.ResultAction.KEEP;
    }

    @Override
    public final ProcessType getProcessType() {
        return this.processType;
    }

    @Override
    public final RunningMode getRunningMode() {
        return this.runningMode;
    }

    @Override
    public final OperationContext.Type getType() {
        return this.contextType;
    }

    @Override
    public final boolean isNormalServer() {
        return this.processType.isServer() && this.runningMode == RunningMode.NORMAL;
    }

    @Override
    public final boolean isRollbackOnly() {
        return this.resultAction == OperationContext.ResultAction.ROLLBACK;
    }

    @Override
    public final void setRollbackOnly() {
        this.resultAction = OperationContext.ResultAction.ROLLBACK;
    }

    final boolean isRollingBack() {
        return this.currentStage == OperationContext.Stage.DONE && this.resultAction == OperationContext.ResultAction.ROLLBACK;
    }

    @Override
    public final void reloadRequired() {
        if (this.processState.isReloadSupported()) {
            this.activeStep.restartStamp = this.processState.setReloadRequired();
            this.activeStep.response.get(new String[]{"response-headers", "operation-requires-reload"}).set(true);
        } else {
            this.restartRequired();
        }
    }

    @Override
    public final void restartRequired() {
        this.activeStep.restartStamp = this.processState.setRestartRequired();
        this.activeStep.response.get(new String[]{"response-headers", "operation-requires-restart"}).set(true);
    }

    @Override
    public final void revertReloadRequired() {
        if (this.processState.isReloadSupported()) {
            this.processState.revertReloadRequired(this.activeStep.restartStamp);
            if (this.activeStep.response.get("response-headers").hasDefined("operation-requires-reload")) {
                this.activeStep.response.get("response-headers").remove("operation-requires-reload");
                if (this.activeStep.response.get("response-headers").asInt() == 0) {
                    this.activeStep.response.remove("response-headers");
                }
            }
        } else {
            this.revertRestartRequired();
        }
    }

    @Override
    public final void revertRestartRequired() {
        this.processState.revertRestartRequired(this.activeStep.restartStamp);
        if (this.activeStep.response.get("response-headers").hasDefined("operation-requires-restart")) {
            this.activeStep.response.get("response-headers").remove("operation-requires-restart");
            if (this.activeStep.response.get("response-headers").asInt() == 0) {
                this.activeStep.response.remove("response-headers");
            }
        }
    }

    @Override
    public final void runtimeUpdateSkipped() {
        this.activeStep.response.get(new String[]{"response-headers", "runtime-update-skipped"}).set(true);
    }

    @Override
    public final ModelNode getResult() {
        return this.activeStep.response.get("result");
    }

    @Override
    public final boolean hasResult() {
        return this.activeStep.response.has("result");
    }

    @Override
    public final ModelNode getServerResults() {
        if (this.processType != ProcessType.HOST_CONTROLLER) {
            throw ControllerMessages.MESSAGES.serverResultsAccessNotAllowed(ProcessType.HOST_CONTROLLER, this.processType);
        }
        return this.activeStep.response.get("server-groups");
    }

    private boolean hasMoreSteps() {
        boolean more;
        OperationContext.Stage stage = this.currentStage;
        boolean bl = more = !this.steps.get((Object)stage).isEmpty();
        while (!more && stage.hasNext()) {
            more = !this.steps.get((Object)(stage = stage.next())).isEmpty();
        }
        return more;
    }

    boolean isControllingThread() {
        return Thread.currentThread() == this.initiatingThread || controllingThread.get() == this.initiatingThread;
    }

    abstract void releaseStepLocks(Step var1);

    class Step {
        private final OperationStepHandler handler;
        final ModelNode response;
        final ModelNode operation;
        final PathAddress address;
        private Object restartStamp;
        private OperationContext.RollbackHandler rollbackHandler;
        Step predecessor;

        private Step(OperationStepHandler handler, ModelNode response, ModelNode operation, PathAddress address) {
            this.handler = handler;
            this.response = response;
            this.operation = operation;
            this.address = address == null ? PathAddress.pathAddress(operation.get("address")) : address;
            response.get("outcome");
        }

        private void finalizeStep(Throwable toThrow) {
            block10: {
                try {
                    this.finalizeInternal();
                }
                catch (RuntimeException t) {
                    if (toThrow == null) {
                        toThrow = t;
                    }
                }
                catch (Error t) {
                    if (toThrow != null) break block10;
                    toThrow = t;
                }
            }
            Step step = this.predecessor;
            while (step != null) {
                if (step.rollbackHandler != null) {
                    block11: {
                        try {
                            step.finalizeInternal();
                        }
                        catch (RuntimeException t) {
                            if (toThrow == null) {
                                toThrow = t;
                            }
                        }
                        catch (Error t) {
                            if (toThrow != null) break block11;
                            toThrow = t;
                        }
                    }
                    step = step.predecessor;
                    continue;
                }
                AbstractOperationContext.this.activeStep = step;
                break;
            }
            AbstractOperationContext.throwThrowable(toThrow);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finalizeInternal() {
            AbstractOperationContext.this.activeStep = this;
            try {
                this.handleRollback();
                if (AbstractOperationContext.this.currentStage != null && AbstractOperationContext.this.currentStage != OperationContext.Stage.DONE) {
                    AbstractOperationContext.this.currentStage = OperationContext.Stage.DONE;
                    if (!this.response.hasDefined("failure-description")) {
                        this.response.get("failure-description").set(ControllerMessages.MESSAGES.operationHandlerFailedToComplete());
                    }
                    this.response.get("outcome").set(AbstractOperationContext.this.cancelled ? "cancelled" : "failed");
                    this.response.get("rolled-back").set(true);
                    AbstractOperationContext.this.resultAction = AbstractOperationContext.this.getFailedResultAction(null);
                } else if (AbstractOperationContext.this.resultAction == OperationContext.ResultAction.ROLLBACK) {
                    this.response.get("outcome").set(AbstractOperationContext.this.cancelled ? "cancelled" : "failed");
                    this.response.get("rolled-back").set(true);
                } else {
                    this.response.get("outcome").set(this.response.hasDefined("failure-description") ? "failed" : "success");
                }
            }
            finally {
                AbstractOperationContext.this.releaseStepLocks(this);
                if (this.predecessor == null) {
                    AbstractOperationContext.this.currentStage = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleRollback() {
            block9: {
                if (this.rollbackHandler != null) {
                    try {
                        if (AbstractOperationContext.this.resultAction != OperationContext.ResultAction.ROLLBACK) break block9;
                        ClassLoader oldTccl = SecurityActions.setThreadContextClassLoader(this.handler.getClass());
                        try {
                            this.rollbackHandler.handleRollback(AbstractOperationContext.this, this.operation);
                        }
                        finally {
                            SecurityActions.setThreadContextClassLoader(oldTccl);
                        }
                    }
                    catch (Exception e) {
                        AbstractOperationContext.this.report(MessageSeverity.ERROR, ControllerMessages.MESSAGES.stepHandlerFailedRollback(this.handler, this.operation.get("operation").asString(), this.address, e.getLocalizedMessage()));
                    }
                    finally {
                        this.rollbackHandler = null;
                    }
                }
            }
        }
    }

    static enum ContextFlag {
        ROLLBACK_ON_FAIL,
        ALLOW_RESOURCE_SERVICE_RESTART;

    }
}

