/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.registry.ResourceProvider;
import org.jboss.dmr.ModelNode;

class BasicResource
implements Resource {
    private final ModelNode model = new ModelNode();
    private final Map<String, ResourceProvider> children = new LinkedHashMap<String, ResourceProvider>();

    protected BasicResource() {
    }

    @Override
    public ModelNode getModel() {
        return this.model;
    }

    @Override
    public void writeModel(ModelNode newModel) {
        this.model.set(newModel);
    }

    @Override
    public boolean isModelDefined() {
        return this.model.isDefined();
    }

    @Override
    public Resource getChild(PathElement address) {
        ResourceProvider provider = this.getProvider(address.getKey());
        if (provider == null) {
            return null;
        }
        return provider.get(address.getValue());
    }

    @Override
    public boolean hasChild(PathElement address) {
        ResourceProvider provider = this.getProvider(address.getKey());
        if (provider == null) {
            return false;
        }
        if (address.isWildcard()) {
            return provider.hasChildren();
        }
        return provider.has(address.getValue());
    }

    @Override
    public Resource requireChild(PathElement address) {
        Resource resource = this.getChild(address);
        if (resource == null) {
            throw new Resource.NoSuchResourceException(address);
        }
        return resource;
    }

    @Override
    public boolean hasChildren(String childType) {
        ResourceProvider provider = this.getProvider(childType);
        return provider != null && provider.hasChildren();
    }

    @Override
    public Resource navigate(PathAddress address) {
        return Resource.Tools.navigate(this, address);
    }

    @Override
    public Set<String> getChildrenNames(String childType) {
        ResourceProvider provider = this.getProvider(childType);
        if (provider == null) {
            return Collections.emptySet();
        }
        return provider.children();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getChildTypes() {
        Map<String, ResourceProvider> map = this.children;
        synchronized (map) {
            return new LinkedHashSet<String>(this.children.keySet());
        }
    }

    @Override
    public Set<Resource.ResourceEntry> getChildren(final String childType) {
        ResourceProvider provider = this.getProvider(childType);
        if (provider == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Resource.ResourceEntry> children = new LinkedHashSet<Resource.ResourceEntry>();
        for (final String name : provider.children()) {
            Resource resource = provider.get(name);
            children.add(new DelegateResource(resource){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public PathElement getPathElement() {
                    return PathElement.pathElement(childType, name);
                }
            });
        }
        return children;
    }

    @Override
    public void registerChild(PathElement address, Resource resource) {
        if (address.isMultiTarget()) {
            throw new IllegalArgumentException();
        }
        this.getOrCreateProvider(address.getKey()).register(address.getValue(), resource);
    }

    @Override
    public Resource removeChild(PathElement address) {
        ResourceProvider provider = this.getProvider(address.getKey());
        if (provider == null) {
            return null;
        }
        return provider.remove(address.getValue());
    }

    @Override
    public boolean isProxy() {
        return false;
    }

    @Override
    public boolean isRuntime() {
        return false;
    }

    @Override
    public Resource clone() {
        BasicResource clone = new BasicResource();
        clone.writeModel(this.model);
        for (String childType : this.getChildTypes()) {
            for (Resource.ResourceEntry child : this.getChildren(childType)) {
                clone.registerChild(child.getPathElement(), (Resource)child.clone());
            }
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerResourceProvider(String type, ResourceProvider provider) {
        Map<String, ResourceProvider> map = this.children;
        synchronized (map) {
            if (this.children.containsKey(type)) {
                throw ControllerMessages.MESSAGES.duplicateResourceType(type);
            }
            this.children.put(type, provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ResourceProvider getProvider(String type) {
        Map<String, ResourceProvider> map = this.children;
        synchronized (map) {
            return this.children.get(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceProvider getOrCreateProvider(String type) {
        Map<String, ResourceProvider> map = this.children;
        synchronized (map) {
            ResourceProvider provider = this.children.get(type);
            if (provider != null) {
                return provider;
            }
            DefaultResourceProvider newProvider = new DefaultResourceProvider();
            this.children.put(type, newProvider);
            return newProvider;
        }
    }

    static abstract class DelegateResource
    implements Resource.ResourceEntry {
        final Resource delegate;

        protected DelegateResource(Resource delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException();
            }
            this.delegate = delegate;
        }

        @Override
        public Resource getChild(PathElement element) {
            return this.delegate.getChild(element);
        }

        @Override
        public Set<Resource.ResourceEntry> getChildren(String childType) {
            return this.delegate.getChildren(childType);
        }

        @Override
        public Set<String> getChildrenNames(String childType) {
            return this.delegate.getChildrenNames(childType);
        }

        @Override
        public Set<String> getChildTypes() {
            return this.delegate.getChildTypes();
        }

        @Override
        public ModelNode getModel() {
            return this.delegate.getModel();
        }

        @Override
        public boolean hasChild(PathElement element) {
            return this.delegate.hasChild(element);
        }

        @Override
        public boolean hasChildren(String childType) {
            return this.delegate.hasChildren(childType);
        }

        @Override
        public boolean isModelDefined() {
            return this.delegate.isModelDefined();
        }

        @Override
        public Resource navigate(PathAddress address) {
            return this.delegate.navigate(address);
        }

        @Override
        public void registerChild(PathElement address, Resource resource) {
            this.delegate.registerChild(address, resource);
        }

        @Override
        public Resource removeChild(PathElement address) {
            return this.delegate.removeChild(address);
        }

        @Override
        public Resource requireChild(PathElement element) {
            return this.delegate.requireChild(element);
        }

        @Override
        public void writeModel(ModelNode newModel) {
            this.delegate.writeModel(newModel);
        }

        @Override
        public boolean isRuntime() {
            return this.delegate.isRuntime();
        }

        @Override
        public boolean isProxy() {
            return this.delegate.isProxy();
        }

        @Override
        public Resource clone() {
            return this.delegate.clone();
        }
    }

    static class DefaultResourceProvider
    implements ResourceProvider {
        private final Map<String, Resource> children = new LinkedHashMap<String, Resource>();

        protected DefaultResourceProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<String> children() {
            Map<String, Resource> map = this.children;
            synchronized (map) {
                return new LinkedHashSet<String>(this.children.keySet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean has(String name) {
            Map<String, Resource> map = this.children;
            synchronized (map) {
                return this.children.get(name) != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Resource get(String name) {
            Map<String, Resource> map = this.children;
            synchronized (map) {
                return this.children.get(name);
            }
        }

        @Override
        public boolean hasChildren() {
            return !this.children().isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void register(String name, Resource resource) {
            Map<String, Resource> map = this.children;
            synchronized (map) {
                if (this.children.containsKey(name)) {
                    throw ControllerMessages.MESSAGES.duplicateResource(name);
                }
                this.children.put(name, resource);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Resource remove(String name) {
            Map<String, Resource> map = this.children;
            synchronized (map) {
                return this.children.remove(name);
            }
        }
    }
}

