/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions.common;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ExtensionDescription {
    public static final String MODULE = "module";
    private static final String RESOURCE_NAME = ExtensionDescription.class.getPackage().getName() + ".LocalDescriptions";

    public static ModelNode getExtensionDescription(Locale locale) {
        ResourceBundle bundle2 = ExtensionDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("extension"));
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(false);
        root.get(new String[]{"attributes", MODULE, "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", MODULE, "description"}).set(bundle2.getString("extension.module"));
        root.get(new String[]{"attributes", MODULE, "required"}).set(true);
        root.get(new String[]{"attributes", MODULE, "min-length"}).set(1);
        root.get(new String[]{"attributes", MODULE, "nillable"}).set(false);
        root.get("operations");
        return root;
    }

    public static ModelNode getExtensionAddOperation(Locale locale) {
        ResourceBundle bundle2 = ExtensionDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("add");
        root.get("description").set(bundle2.getString("extension.add"));
        root.get("request-properties").setEmptyObject();
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getExtensionRemoveOperation(Locale locale) {
        ResourceBundle bundle2 = ExtensionDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("remove");
        root.get("description").set(bundle2.getString("extension.remove"));
        root.get("request-properties").setEmptyObject();
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    public static void main(String[] args) {
        ModelNode desc = ExtensionDescription.getExtensionDescription(null);
        desc.get(new String[]{"operations", "add"}).set(ExtensionDescription.getExtensionAddOperation(null));
        desc.get(new String[]{"operations", "remove"}).set(ExtensionDescription.getExtensionRemoveOperation(null));
        System.out.println(desc);
        ModelNode node = new ModelNode().add("profile").add("web").add("subsystem").add("remoting");
        System.out.println(node);
        System.out.println(PathAddress.pathAddress(node).toModelNode());
    }
}

