/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.controller.AbstractOperationContext;
import org.jboss.as.controller.ContainerStateMonitor;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelControllerImpl;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.DelegatingImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.BatchServiceTarget;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

final class OperationContextImpl
extends AbstractOperationContext {
    private static final Object NULL = new Object();
    private final ModelControllerImpl modelController;
    private final EnumSet<AbstractOperationContext.ContextFlag> contextFlags;
    private final OperationMessageHandler messageHandler;
    private final ServiceTarget serviceTarget;
    private final Map<ServiceName, ServiceController<?>> realRemovingControllers = new HashMap();
    private final Map<ServiceName, AbstractOperationContext.Step> removalSteps = new HashMap<ServiceName, AbstractOperationContext.Step>();
    private final OperationAttachments attachments;
    private final Map<PathAddress, Object> affectsModel;
    private Map<PathAddress, Object> restartedResources = Collections.emptyMap();
    private volatile boolean affectsResourceRegistration;
    private boolean respectInterruption = true;
    private volatile Resource model;
    private volatile Resource originalModel;
    private volatile boolean affectsRuntime;
    private AbstractOperationContext.Step lockStep;
    private AbstractOperationContext.Step containerMonitorStep;

    OperationContextImpl(ModelControllerImpl modelController, ProcessType processType, RunningMode runningMode, EnumSet<AbstractOperationContext.ContextFlag> contextFlags, OperationMessageHandler messageHandler, OperationAttachments attachments, Resource model, ModelController.OperationTransactionControl transactionControl, ControlledProcessState processState, boolean booting) {
        super(processType, runningMode, transactionControl, processState, booting);
        this.model = model;
        this.originalModel = model;
        this.modelController = modelController;
        this.messageHandler = messageHandler;
        this.attachments = attachments;
        this.affectsModel = booting ? new ConcurrentHashMap(256) : new HashMap(1);
        this.contextFlags = contextFlags;
        this.serviceTarget = new ContextServiceTarget(modelController);
    }

    @Override
    public InputStream getAttachmentStream(int index) {
        if (this.attachments == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (InputStream)this.attachments.getInputStreams().get(index);
    }

    @Override
    public int getAttachmentStreamCount() {
        return this.attachments == null ? 0 : this.attachments.getInputStreams().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void awaitModelControllerContainerMonitor() throws InterruptedException {
        if (this.affectsRuntime) {
            Map<ServiceName, ServiceController<?>> map;
            ControllerLogger.MGMT_OP_LOGGER.debugf("Entered VERIFY stage; waiting for service container to settle", new Object[0]);
            Map<ServiceName, ServiceController<?>> map2 = map = this.realRemovingControllers;
            synchronized (map2) {
                while (!map.isEmpty()) {
                    map.wait();
                }
            }
            ContainerStateMonitor.ContainerStateChangeReport changeReport = this.modelController.awaitContainerStateChangeReport(1);
            if (changeReport != null && !changeReport.getMissingServices().isEmpty()) {
                ServiceRemovalVerificationHandler removalVerificationHandler = new ServiceRemovalVerificationHandler(changeReport);
                this.addStep(new ModelNode(), new ModelNode(), PathAddress.EMPTY_ADDRESS, removalVerificationHandler, OperationContext.Stage.VERIFY);
            }
        }
    }

    @Override
    ConfigurationPersister.PersistenceResource createPersistenceResource() throws ConfigurationPersistenceException {
        return this.modelController.writeModel(this.model, this.affectsModel.keySet());
    }

    @Override
    public boolean isRollbackOnRuntimeFailure() {
        return this.contextFlags.contains((Object)AbstractOperationContext.ContextFlag.ROLLBACK_ON_FAIL);
    }

    @Override
    public boolean isResourceServiceRestartAllowed() {
        return this.contextFlags.contains((Object)AbstractOperationContext.ContextFlag.ALLOW_RESOURCE_SERVICE_RESTART);
    }

    @Override
    public ManagementResourceRegistration getResourceRegistrationForUpdate() {
        PathAddress address = this.activeStep.address;
        assert (this.isControllingThread());
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw ControllerMessages.MESSAGES.operationAlreadyComplete();
        }
        if (!this.affectsResourceRegistration) {
            this.takeWriteLock();
            this.affectsResourceRegistration = true;
        }
        return this.modelController.getRootRegistration().getSubModel(address);
    }

    @Override
    public ImmutableManagementResourceRegistration getResourceRegistration() {
        PathAddress address = this.activeStep.address;
        assert (this.isControllingThread());
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null || currentStage == OperationContext.Stage.DONE) {
            throw ControllerMessages.MESSAGES.operationAlreadyComplete();
        }
        ManagementResourceRegistration delegate = this.modelController.getRootRegistration().getSubModel(address);
        return delegate == null ? null : new DelegatingImmutableManagementResourceRegistration(delegate);
    }

    @Override
    public ServiceRegistry getServiceRegistry(boolean modify) throws UnsupportedOperationException {
        assert (this.isControllingThread());
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw ControllerMessages.MESSAGES.operationAlreadyComplete();
        }
        if (modify && currentStage != OperationContext.Stage.RUNTIME && currentStage != OperationContext.Stage.MODEL && currentStage != OperationContext.Stage.VERIFY && !this.isRollingBack()) {
            throw ControllerMessages.MESSAGES.serviceRegistryRuntimeOperationsOnly();
        }
        if (modify && !this.affectsRuntime) {
            this.takeWriteLock();
            this.affectsRuntime = true;
            this.acquireContainerMonitor();
            this.awaitContainerMonitor();
        }
        return this.modelController.getServiceRegistry();
    }

    @Override
    public ServiceController<?> removeService(ServiceName name) throws UnsupportedOperationException {
        ServiceController controller;
        assert (this.isControllingThread());
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw ControllerMessages.MESSAGES.operationAlreadyComplete();
        }
        if (currentStage != OperationContext.Stage.RUNTIME && currentStage != OperationContext.Stage.VERIFY && !this.isRollingBack()) {
            throw ControllerMessages.MESSAGES.serviceRemovalRuntimeOperationsOnly();
        }
        if (!this.affectsRuntime) {
            this.takeWriteLock();
            this.affectsRuntime = true;
            this.acquireContainerMonitor();
            this.awaitContainerMonitor();
        }
        if ((controller = this.modelController.getServiceRegistry().getService(name)) != null) {
            this.doRemove(controller);
        }
        return controller;
    }

    @Override
    public boolean markResourceRestarted(PathAddress resource, Object owner) {
        if (this.restartedResources.containsKey(resource)) {
            return false;
        }
        if (this.restartedResources == Collections.EMPTY_MAP) {
            this.restartedResources = new HashMap<PathAddress, Object>();
        }
        this.restartedResources.put(resource, owner);
        return true;
    }

    @Override
    public boolean revertResourceRestarted(PathAddress resource, Object owner) {
        if (this.restartedResources.get(resource) == owner) {
            this.restartedResources.remove(resource);
            return true;
        }
        return false;
    }

    @Override
    public void removeService(ServiceController<?> controller) throws UnsupportedOperationException {
        assert (this.isControllingThread());
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw ControllerMessages.MESSAGES.operationAlreadyComplete();
        }
        if (currentStage != OperationContext.Stage.RUNTIME && currentStage != OperationContext.Stage.VERIFY && !this.isRollingBack()) {
            throw ControllerMessages.MESSAGES.serviceRemovalRuntimeOperationsOnly();
        }
        if (!this.affectsRuntime) {
            this.takeWriteLock();
            this.affectsRuntime = true;
            this.acquireContainerMonitor();
            this.awaitContainerMonitor();
        }
        this.doRemove(controller);
    }

    private void doRemove(ServiceController<?> controller) {
        final AbstractOperationContext.Step removalStep = this.activeStep;
        controller.addListener((ServiceListener)new AbstractServiceListener<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void listenerAdded(ServiceController<?> controller) {
                Map map;
                Map map2 = map = OperationContextImpl.this.realRemovingControllers;
                synchronized (map2) {
                    map.put(controller.getName(), controller);
                    controller.setMode(ServiceController.Mode.REMOVE);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void transition(ServiceController<?> controller, ServiceController.Transition transition) {
                switch (transition) {
                    case REMOVING_to_REMOVED: 
                    case REMOVING_to_DOWN: {
                        Map map;
                        Map map2 = map = OperationContextImpl.this.realRemovingControllers;
                        synchronized (map2) {
                            ServiceName name = controller.getName();
                            if (map.get(name) == controller) {
                                map.remove(controller.getName());
                                OperationContextImpl.this.removalSteps.put(name, removalStep);
                                map.notifyAll();
                            }
                            break;
                        }
                    }
                }
            }
        });
    }

    @Override
    public ServiceTarget getServiceTarget() throws UnsupportedOperationException {
        assert (this.isControllingThread());
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw ControllerMessages.MESSAGES.operationAlreadyComplete();
        }
        if (currentStage != OperationContext.Stage.RUNTIME && currentStage != OperationContext.Stage.VERIFY && !this.isRollingBack()) {
            throw ControllerMessages.MESSAGES.serviceTargetRuntimeOperationsOnly();
        }
        if (!this.affectsRuntime) {
            this.takeWriteLock();
            this.affectsRuntime = true;
            this.acquireContainerMonitor();
            this.awaitContainerMonitor();
        }
        return this.serviceTarget;
    }

    private void takeWriteLock() {
        if (this.lockStep == null) {
            if (this.currentStage == OperationContext.Stage.DONE) {
                throw ControllerMessages.MESSAGES.invalidModificationAfterCompletedStep();
            }
            try {
                this.modelController.acquireLock(this.respectInterruption);
                this.lockStep = this.activeStep;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw ControllerMessages.MESSAGES.operationCancelledAsynchronously();
            }
        }
    }

    private void acquireContainerMonitor() {
        if (this.containerMonitorStep == null) {
            if (this.currentStage == OperationContext.Stage.DONE) {
                throw ControllerMessages.MESSAGES.invalidModificationAfterCompletedStep();
            }
            this.modelController.acquireContainerMonitor();
            this.containerMonitorStep = this.activeStep;
        }
    }

    private void awaitContainerMonitor() {
        try {
            this.modelController.awaitContainerMonitor(this.respectInterruption, 1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ControllerMessages.MESSAGES.operationCancelledAsynchronously();
        }
    }

    @Override
    public ModelNode readModel(PathAddress requestAddress) {
        PathAddress address = this.activeStep.address.append(requestAddress);
        assert (this.isControllingThread());
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw ControllerMessages.MESSAGES.operationAlreadyComplete();
        }
        Resource model = this.model;
        for (PathElement element : address) {
            model = OperationContextImpl.requireChild(model, element, address);
        }
        return Resource.Tools.readModel(model);
    }

    @Override
    public ModelNode readModelForUpdate(PathAddress requestAddress) {
        PathAddress address = this.activeStep.address.append(requestAddress);
        assert (this.isControllingThread());
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw ControllerMessages.MESSAGES.operationAlreadyComplete();
        }
        if (currentStage != OperationContext.Stage.MODEL) {
            throw ControllerMessages.MESSAGES.stageAlreadyComplete(OperationContext.Stage.MODEL);
        }
        if (!this.isModelAffected()) {
            this.takeWriteLock();
            this.model = this.model.clone();
        }
        this.affectsModel.put(address, NULL);
        Resource model = this.model;
        Iterator i = address.iterator();
        while (i.hasNext()) {
            PathElement element = (PathElement)i.next();
            if (element.isMultiTarget()) {
                throw ControllerMessages.MESSAGES.cannotWriteTo("*");
            }
            if (!i.hasNext()) {
                String key = element.getKey();
                if (!model.hasChild(element)) {
                    PathAddress parent = address.subAddress(0, address.size() - 1);
                    Set<String> childrenNames = this.modelController.getRootRegistration().getChildNames(parent);
                    if (!childrenNames.contains(key)) {
                        throw ControllerMessages.MESSAGES.noChildType(key);
                    }
                    Resource newModel = Resource.Factory.create();
                    model.registerChild(element, newModel);
                    model = newModel;
                    continue;
                }
                model = OperationContextImpl.requireChild(model, element, address);
                continue;
            }
            model = OperationContextImpl.requireChild(model, element, address);
        }
        if (model == null) {
            throw new IllegalStateException();
        }
        return model.getModel();
    }

    @Override
    public Resource readResource(PathAddress requestAddress) {
        PathAddress address = this.activeStep.address.append(requestAddress);
        assert (this.isControllingThread());
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw ControllerMessages.MESSAGES.operationAlreadyComplete();
        }
        Resource model = this.model;
        for (PathElement element : address) {
            model = OperationContextImpl.requireChild(model, element, address);
        }
        return model.clone();
    }

    @Override
    public Resource readResourceForUpdate(PathAddress requestAddress) {
        PathAddress address = this.activeStep.address.append(requestAddress);
        assert (this.isControllingThread());
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw ControllerMessages.MESSAGES.operationAlreadyComplete();
        }
        if (currentStage != OperationContext.Stage.MODEL) {
            throw ControllerMessages.MESSAGES.stageAlreadyComplete(OperationContext.Stage.MODEL);
        }
        if (!this.isModelAffected()) {
            this.takeWriteLock();
            this.model = this.model.clone();
        }
        this.affectsModel.put(address, NULL);
        Resource resource = this.model;
        for (PathElement element : address) {
            if (element.isMultiTarget()) {
                throw ControllerMessages.MESSAGES.cannotWriteTo("*");
            }
            resource = OperationContextImpl.requireChild(resource, element, address);
        }
        return resource;
    }

    @Override
    public Resource getOriginalRootResource() {
        return this.originalModel.clone();
    }

    @Override
    public Resource createResource(PathAddress relativeAddress) {
        Resource toAdd = Resource.Factory.create();
        this.addResource(relativeAddress, toAdd);
        return toAdd;
    }

    @Override
    public void addResource(PathAddress relativeAddress, Resource toAdd) {
        PathAddress absoluteAddress = this.activeStep.address.append(relativeAddress);
        assert (this.isControllingThread());
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw ControllerMessages.MESSAGES.operationAlreadyComplete();
        }
        if (currentStage != OperationContext.Stage.MODEL) {
            throw ControllerMessages.MESSAGES.stageAlreadyComplete(OperationContext.Stage.MODEL);
        }
        if (absoluteAddress.size() == 0) {
            throw ControllerMessages.MESSAGES.duplicateResourceAddress(absoluteAddress);
        }
        if (!this.isModelAffected()) {
            this.takeWriteLock();
            this.model = this.model.clone();
        }
        this.affectsModel.put(absoluteAddress, NULL);
        Resource model = this.model;
        Iterator i = absoluteAddress.iterator();
        while (i.hasNext()) {
            PathElement element = (PathElement)i.next();
            if (element.isMultiTarget()) {
                throw ControllerMessages.MESSAGES.cannotWriteTo("*");
            }
            if (!i.hasNext()) {
                String key = element.getKey();
                if (model.hasChild(element)) {
                    throw ControllerMessages.MESSAGES.duplicateResourceAddress(absoluteAddress);
                }
                PathAddress parent = absoluteAddress.subAddress(0, absoluteAddress.size() - 1);
                Set<String> childrenNames = this.modelController.getRootRegistration().getChildNames(parent);
                if (!childrenNames.contains(key)) {
                    throw ControllerMessages.MESSAGES.noChildType(key);
                }
                model.registerChild(element, toAdd);
                model = toAdd;
                continue;
            }
            if ((model = model.getChild(element)) != null) continue;
            PathAddress ancestor = PathAddress.EMPTY_ADDRESS;
            for (PathElement pe : absoluteAddress) {
                ancestor = ancestor.append(pe);
                if (!element.equals(pe)) continue;
                break;
            }
            throw ControllerMessages.MESSAGES.resourceNotFound(ancestor, absoluteAddress);
        }
    }

    @Override
    public Resource removeResource(PathAddress requestAddress) {
        PathAddress address = this.activeStep.address.append(requestAddress);
        assert (this.isControllingThread());
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw ControllerMessages.MESSAGES.operationAlreadyComplete();
        }
        if (currentStage != OperationContext.Stage.MODEL) {
            throw ControllerMessages.MESSAGES.stageAlreadyComplete(OperationContext.Stage.MODEL);
        }
        if (!this.isModelAffected()) {
            this.takeWriteLock();
            this.model = this.model.clone();
        }
        this.affectsModel.put(address, NULL);
        Resource model = this.model;
        Iterator i = address.iterator();
        while (i.hasNext()) {
            PathElement element = (PathElement)i.next();
            if (element.isMultiTarget()) {
                throw ControllerMessages.MESSAGES.cannotRemove("*");
            }
            if (!i.hasNext()) {
                model = model.removeChild(element);
                continue;
            }
            model = OperationContextImpl.requireChild(model, element, address);
        }
        return model;
    }

    @Override
    public void acquireControllerLock() {
        this.takeWriteLock();
    }

    @Override
    public Resource getRootResource() {
        Resource readOnlyModel = this.model;
        return readOnlyModel.clone();
    }

    @Override
    public boolean isModelAffected() {
        return this.affectsModel.size() > 0;
    }

    @Override
    public boolean isRuntimeAffected() {
        return this.affectsRuntime;
    }

    @Override
    public boolean isResourceRegistryAffected() {
        return this.affectsResourceRegistration;
    }

    @Override
    public OperationContext.Stage getCurrentStage() {
        return this.currentStage;
    }

    @Override
    public void report(MessageSeverity severity, String message) {
        try {
            if (this.messageHandler != null) {
                this.messageHandler.handleReport(severity, message);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    void releaseStepLocks(AbstractOperationContext.Step step) {
        if (this.lockStep == step) {
            this.modelController.releaseLock();
            this.lockStep = null;
        }
        if (this.containerMonitorStep == step) {
            this.awaitContainerMonitor();
            this.modelController.releaseContainerMonitor();
            this.containerMonitorStep = null;
        }
    }

    private static Resource requireChild(Resource resource, PathElement childPath, PathAddress fullAddress) {
        if (resource.hasChild(childPath)) {
            return resource.requireChild(childPath);
        }
        PathAddress missing = PathAddress.EMPTY_ADDRESS;
        for (PathElement search : fullAddress) {
            missing = missing.append(search);
            if (!search.equals(childPath)) continue;
            break;
        }
        throw ControllerMessages.MESSAGES.managementResourceNotFound(missing);
    }

    @Override
    public ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
        return this.modelController.resolveExpressions(node);
    }

    private class ServiceRemovalVerificationHandler
    implements OperationStepHandler {
        private final ContainerStateMonitor.ContainerStateChangeReport containerStateChangeReport;

        private ServiceRemovalVerificationHandler(ContainerStateMonitor.ContainerStateChangeReport containerStateChangeReport) {
            this.containerStateChangeReport = containerStateChangeReport;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Map mutex;
            HashMap<AbstractOperationContext.Step, HashMap<ServiceName, Set<ServiceName>>> missingByStep = new HashMap<AbstractOperationContext.Step, HashMap<ServiceName, Set<ServiceName>>>();
            Map map = mutex = OperationContextImpl.this.realRemovingControllers;
            synchronized (map) {
                for (Map.Entry<ServiceName, ContainerStateMonitor.MissingDependencyInfo> entry : this.containerStateChangeReport.getMissingServices().entrySet()) {
                    ContainerStateMonitor.MissingDependencyInfo missingDependencyInfo = entry.getValue();
                    AbstractOperationContext.Step removalStep = (AbstractOperationContext.Step)OperationContextImpl.this.removalSteps.get(entry.getKey());
                    if (removalStep == null) continue;
                    HashMap<ServiceName, Set<ServiceName>> stepBadRemovals = (HashMap<ServiceName, Set<ServiceName>>)missingByStep.get(removalStep);
                    if (stepBadRemovals == null) {
                        stepBadRemovals = new HashMap<ServiceName, Set<ServiceName>>();
                        missingByStep.put(removalStep, stepBadRemovals);
                    }
                    stepBadRemovals.put(entry.getKey(), missingDependencyInfo.getDependents());
                }
            }
            for (Map.Entry entry : missingByStep.entrySet()) {
                AbstractOperationContext.Step step = (AbstractOperationContext.Step)entry.getKey();
                if (step.response.hasDefined("failure-description")) continue;
                StringBuilder sb = new StringBuilder(ControllerMessages.MESSAGES.removingServiceUnsatisfiedDependencies());
                for (Map.Entry removed : ((Map)entry.getValue()).entrySet()) {
                    sb.append(ControllerMessages.MESSAGES.removingServiceUnsatisfiedDependencies(((ServiceName)removed.getKey()).getCanonicalName()));
                    boolean first = true;
                    for (ServiceName dependent : (Set)removed.getValue()) {
                        if (!first) {
                            sb.append(", ");
                        } else {
                            first = false;
                        }
                        sb.append(dependent);
                    }
                }
                step.response.get("failure-description").set(sb.toString());
            }
            if (!missingByStep.isEmpty() && context.isRollbackOnRuntimeFailure()) {
                context.setRollbackOnly();
            }
            context.completeStep();
        }
    }

    class ContextServiceBuilder<T>
    implements ServiceBuilder<T> {
        private final ServiceBuilder<T> realBuilder;
        private final ServiceName name;

        ContextServiceBuilder(ServiceBuilder<T> realBuilder, ServiceName name) {
            this.realBuilder = realBuilder;
            this.name = name;
        }

        public ServiceBuilder<T> addAliases(ServiceName ... aliases) {
            this.realBuilder.addAliases(aliases);
            return this;
        }

        public ServiceBuilder<T> setInitialMode(ServiceController.Mode mode) {
            this.realBuilder.setInitialMode(mode);
            return this;
        }

        public ServiceBuilder<T> addDependencies(ServiceName ... dependencies) {
            this.realBuilder.addDependencies(dependencies);
            return this;
        }

        public ServiceBuilder<T> addDependencies(ServiceBuilder.DependencyType dependencyType, ServiceName ... dependencies) {
            this.realBuilder.addDependencies(dependencyType, dependencies);
            return this;
        }

        public ServiceBuilder<T> addDependencies(Iterable<ServiceName> dependencies) {
            this.realBuilder.addDependencies(dependencies);
            return this;
        }

        public ServiceBuilder<T> addDependencies(ServiceBuilder.DependencyType dependencyType, Iterable<ServiceName> dependencies) {
            this.realBuilder.addDependencies(dependencyType, dependencies);
            return this;
        }

        public ServiceBuilder<T> addDependency(ServiceName dependency) {
            this.realBuilder.addDependency(dependency);
            return this;
        }

        public ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency) {
            this.realBuilder.addDependency(dependencyType, dependency);
            return this;
        }

        public ServiceBuilder<T> addDependency(ServiceName dependency, Injector<Object> target) {
            this.realBuilder.addDependency(dependency, target);
            return this;
        }

        public ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency, Injector<Object> target) {
            this.realBuilder.addDependency(dependencyType, dependency, target);
            return this;
        }

        public <I> ServiceBuilder<T> addDependency(ServiceName dependency, Class<I> type, Injector<I> target) {
            this.realBuilder.addDependency(dependency, type, target);
            return this;
        }

        public <I> ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency, Class<I> type, Injector<I> target) {
            this.realBuilder.addDependency(dependencyType, dependency, type, target);
            return this;
        }

        public <I> ServiceBuilder<T> addInjection(Injector<? super I> target, I value) {
            this.realBuilder.addInjection(target, value);
            return this;
        }

        public <I> ServiceBuilder<T> addInjectionValue(Injector<? super I> target, Value<I> value) {
            this.realBuilder.addInjectionValue(target, value);
            return this;
        }

        public ServiceBuilder<T> addInjection(Injector<? super T> target) {
            this.realBuilder.addInjection(target);
            return this;
        }

        public ServiceBuilder<T> addListener(ServiceListener<? super T> listener) {
            this.realBuilder.addListener(listener);
            return this;
        }

        public ServiceBuilder<T> addListener(ServiceListener<? super T> ... listeners) {
            this.realBuilder.addListener(listeners);
            return this;
        }

        public ServiceBuilder<T> addListener(Collection<? extends ServiceListener<? super T>> listeners) {
            this.realBuilder.addListener(listeners);
            return this;
        }

        public ServiceBuilder<T> addListener(ServiceListener.Inheritance inheritance, ServiceListener<? super T> listener) {
            this.realBuilder.addListener(inheritance, listener);
            return this;
        }

        public ServiceBuilder<T> addListener(ServiceListener.Inheritance inheritance, ServiceListener<? super T> ... listeners) {
            this.realBuilder.addListener(inheritance, listeners);
            return this;
        }

        public ServiceBuilder<T> addListener(ServiceListener.Inheritance inheritance, Collection<? extends ServiceListener<? super T>> listeners) {
            this.realBuilder.addListener(inheritance, listeners);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        public ServiceController<T> install() throws ServiceRegistryException, IllegalStateException {
            Map map;
            Map map2 = map = OperationContextImpl.this.realRemovingControllers;
            synchronized (map2) {
                block15: {
                    while (map.containsKey(this.name)) {
                        try {
                            map.wait();
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                            throw ControllerMessages.MESSAGES.serviceInstallCancelled();
                        }
                    }
                    boolean intr = false;
                    while (true) {
                        ServiceController serviceController;
                        if (!map.containsKey(this.name)) break block15;
                        try {
                            map.wait();
                            OperationContextImpl.this.removalSteps.remove(this.name);
                            serviceController = this.realBuilder.install();
                        }
                        catch (InterruptedException e) {
                            if (OperationContextImpl.this.respectInterruption) {
                                Thread.currentThread().interrupt();
                                throw ControllerMessages.MESSAGES.serviceInstallCancelled();
                            }
                            intr = true;
                            continue;
                        }
                        return serviceController;
                    }
                    finally {
                        if (intr) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                OperationContextImpl.this.removalSteps.remove(this.name);
                return this.realBuilder.install();
            }
        }
    }

    class ContextServiceTarget
    implements ServiceTarget {
        private final ModelControllerImpl modelController;

        ContextServiceTarget(ModelControllerImpl modelController) {
            this.modelController = modelController;
        }

        public <T> ServiceBuilder<T> addServiceValue(ServiceName name, Value<? extends Service<T>> value) {
            ServiceBuilder realBuilder = this.modelController.getServiceTarget().addServiceValue(name, value);
            return new ContextServiceBuilder(realBuilder, name);
        }

        public <T> ServiceBuilder<T> addService(ServiceName name, Service<T> service) {
            return this.addServiceValue(name, (Value<? extends Service<T>>)new ImmediateValue(service));
        }

        public ServiceTarget addListener(ServiceListener<Object> listener) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget addListener(ServiceListener<Object> ... listeners) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget addListener(Collection<ServiceListener<Object>> listeners) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget addListener(ServiceListener.Inheritance inheritance, ServiceListener<Object> listener) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget addListener(ServiceListener.Inheritance inheritance, ServiceListener<Object> ... listeners) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget addListener(ServiceListener.Inheritance inheritance, Collection<ServiceListener<Object>> listeners) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget removeListener(ServiceListener<Object> listener) {
            throw new UnsupportedOperationException();
        }

        public Set<ServiceListener<Object>> getListeners() {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget addDependency(ServiceName dependency) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget addDependency(ServiceName ... dependencies) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget addDependency(Collection<ServiceName> dependencies) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget removeDependency(ServiceName dependency) {
            throw new UnsupportedOperationException();
        }

        public Set<ServiceName> getDependencies() {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget subTarget() {
            throw new UnsupportedOperationException();
        }

        public BatchServiceTarget batchTarget() {
            throw new UnsupportedOperationException();
        }
    }
}

