/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions.common;

import java.util.Arrays;
import java.util.List;
import org.jboss.dmr.ModelNode;

public class Examples {
    public static ModelNode getUpdatePlan() {
        ModelNode op = new ModelNode();
        op.get("op").set("write-core-threads");
        op.get("op-addr").add("profile", "production");
        op.get("op-addr").add("subsystem", "threads");
        op.get("op-addr").add("bounded-queue-thread-pool", "pool1");
        op.get("count").set(0);
        op.get("per-cpu").set(20);
        op.get(new String[]{"rollout-plan", "rollback-across-groups"}).set(false);
        ModelNode set0 = op.get(new String[]{"rollout-plan", "in-series"}).add();
        set0.get(new String[]{"concurrent-groups", "groupA", "rolling-to-servers"}).set(true);
        set0.get(new String[]{"concurrent-groups", "groupA", "max-failure-percentage"}).set(20);
        set0.get(new String[]{"concurrent-groups", "groupB"});
        ModelNode set1 = op.get(new String[]{"rollout-plan", "in-series"}).add();
        set1.get(new String[]{"server-group", "groupC"});
        set0.get(new String[]{"server-group", "groupC", "rolling-to-servers"}).set(false);
        set0.get(new String[]{"server-group", "groupC", "max-failed-servers"}).set(1);
        ModelNode set2 = op.get(new String[]{"rollout-plan", "in-series"}).add();
        set2.get(new String[]{"concurrent-groups", "groupD", "rolling-to-servers"}).set(true);
        set2.get(new String[]{"concurrent-groups", "groupD", "max-failure-percentage"}).set(20);
        set2.get(new String[]{"concurrent-groups", "groupE"});
        return op;
    }

    public static List<ModelNode> getSimpleResults() {
        ModelNode failed = new ModelNode();
        failed.get("success").set(false);
        failed.get("failure-description").set("[DOM-1234] Some failure message");
        ModelNode void_success = new ModelNode();
        void_success.get("success").set(true);
        void_success.get("result").set(new ModelNode());
        void_success.get("compensating-op").set(new ModelNode());
        ModelNode obj_success = new ModelNode();
        obj_success.get("success").set(true);
        ModelNode result = new ModelNode();
        result.get("name").set("Brian");
        result.get("age").set(22);
        obj_success.get("result").set(result);
        obj_success.get("compensating-op").set(new ModelNode());
        ModelNode comp = new ModelNode();
        comp.get("success").set(true);
        comp.get("result").set(new ModelNode());
        ModelNode op = new ModelNode();
        op.get("op").set("write-core-threads");
        op.get("op-addr").add("profile", "production");
        op.get("op-addr").add("subsystem", "threads");
        op.get("op-addr").add("bounded-queue-thread-pool", "pool1");
        op.get("count").set(5);
        op.get("per-cpu").set(5);
        comp.get("compensating-op").set(op);
        ModelNode cancelled = new ModelNode();
        cancelled.get("success").set(false);
        cancelled.get("cancelled").set(true);
        ModelNode rollback_success = new ModelNode();
        rollback_success.get("success").set(false);
        rollback_success.get("result").set(result);
        rollback_success.get("rolled-back").set(true);
        ModelNode rollback_failure = new ModelNode();
        rollback_failure.get("success").set(false);
        rollback_failure.get("result").set(result);
        rollback_failure.get("rollback-failure-description").set("[DOM-9876] Some failure message");
        ModelNode failed_rolledback = failed.clone();
        failed_rolledback.get("rolled-back").set(true);
        ModelNode multiGood = new ModelNode();
        multiGood.get("success").set(true);
        multiGood.get("result").add(obj_success);
        multiGood.get("result").add(comp);
        multiGood.get(new String[]{"compensating-op", "op"}).set("composite");
        multiGood.get(new String[]{"compensating-op", "op-addr"}).setEmptyList();
        multiGood.get(new String[]{"compensating-op", "steps"}).add(op);
        ModelNode multiBad = new ModelNode();
        multiBad.get("success").set(false);
        multiBad.get("failure-description").set("[DOM-9999] Composite operation failed; see individual operation results for details");
        multiBad.get("result").add(rollback_success);
        multiBad.get("result").add(failed_rolledback);
        multiBad.get("result").add(cancelled);
        return Arrays.asList(failed, void_success, obj_success, comp, cancelled, rollback_success, rollback_failure, multiGood, multiBad);
    }

    public static List<ModelNode> getMultiServerResults() {
        ModelNode success = new ModelNode();
        success.get("outcome").set("success");
        success.get(new String[]{"server-groups", "groupA", "serverA-1", "host"}).set("host1");
        success.get(new String[]{"server-groups", "groupA", "serverA-1", "response", "outcome"}).set("success");
        success.get(new String[]{"server-groups", "groupA", "serverA-1", "response", "result"}).set(new ModelNode());
        success.get(new String[]{"server-groups", "groupA", "serverA-2", "host"}).set("host2");
        success.get(new String[]{"server-groups", "groupA", "serverA-2", "response", "outcome"}).set("success");
        success.get(new String[]{"server-groups", "groupA", "serverA-2", "response", "result"}).set(new ModelNode());
        success.get(new String[]{"server-groups", "groupB", "serverB-1", "host"}).set("host1");
        success.get(new String[]{"server-groups", "groupB", "serverB-1", "response", "outcome"}).set("success");
        success.get(new String[]{"server-groups", "groupB", "serverB-1", "response", "result"}).set(new ModelNode());
        success.get(new String[]{"server-groups", "groupB", "serverB-2", "host"}).set("host2");
        success.get(new String[]{"server-groups", "groupB", "serverB-2", "response", "outcome"}).set("success");
        success.get(new String[]{"server-groups", "groupB", "serverB-2", "response", "result"}).set(new ModelNode());
        ModelNode op = new ModelNode();
        op.get("op").set("write-core-threads");
        op.get("op-addr").add("profile", "production");
        op.get("op-addr").add("subsystem", "threads");
        op.get("op-addr").add("bounded-queue-thread-pool", "pool1");
        op.get("count").set(5);
        op.get("per-cpu").set(5);
        success.get("compensating-op").set(op);
        ModelNode partial = new ModelNode();
        partial.get("outcome").set("success");
        partial.get(new String[]{"server-groups", "groupA", "serverA-1", "host"}).set("host1");
        partial.get(new String[]{"server-groups", "groupA", "serverA-1", "response", "outcome"}).set("success");
        partial.get(new String[]{"server-groups", "groupA", "serverA-1", "response", "result"}).set(new ModelNode());
        partial.get(new String[]{"server-groups", "groupA", "serverA-2", "host"}).set("host2");
        partial.get(new String[]{"server-groups", "groupA", "serverA-2", "response", "outcome"}).set("success");
        partial.get(new String[]{"server-groups", "groupA", "serverA-2", "response", "result"}).set(new ModelNode());
        partial.get(new String[]{"server-groups", "groupB", "serverB-1", "host"}).set("host1");
        partial.get(new String[]{"server-groups", "groupB", "serverB-1", "response", "outcome"}).set("failed");
        partial.get(new String[]{"server-groups", "groupB", "serverB-1", "response", "result"}).set(new ModelNode());
        partial.get(new String[]{"server-groups", "groupB", "serverB-1", "response", "rolled-back"}).set(true);
        partial.get(new String[]{"server-groups", "groupB", "serverB-2", "host"}).set("host2");
        partial.get(new String[]{"server-groups", "groupB", "serverB-2", "response", "outcome"}).set("failed");
        partial.get(new String[]{"server-groups", "groupB", "serverB-2", "response", "result"}).set(new ModelNode());
        partial.get(new String[]{"server-groups", "groupB", "serverB-2", "response", "rolled-back"}).set(true);
        partial.get(new String[]{"server-groups", "groupB", "serverB-3", "host"}).set("host3");
        partial.get(new String[]{"server-groups", "groupB", "serverB-3", "response", "outcome"}).set("failed");
        partial.get(new String[]{"server-groups", "groupB", "serverB-3", "response", "failure-description"}).set("[DOM-4556] Something didn't work right");
        partial.get(new String[]{"server-groups", "groupB", "serverB-3", "response", "rolled-back"}).set(true);
        partial.get("compensating-op").set(op);
        ModelNode failed = new ModelNode();
        failed.get("outcome").set("failed");
        failed.get(new String[]{"server-groups", "groupA", "serverA-1", "host"}).set("host1");
        failed.get(new String[]{"server-groups", "groupA", "serverA-1", "response", "outcome"}).set("success");
        failed.get(new String[]{"server-groups", "groupA", "serverA-1", "response", "result"}).set(new ModelNode());
        failed.get(new String[]{"server-groups", "groupA", "serverA-2", "host"}).set("host2");
        failed.get(new String[]{"server-groups", "groupA", "serverA-2", "response", "outcome"}).set("success");
        failed.get(new String[]{"server-groups", "groupA", "serverA-2", "response", "result"}).set(new ModelNode());
        failed.get(new String[]{"server-groups", "groupB", "serverB-1", "host"}).set("host1");
        failed.get(new String[]{"server-groups", "groupB", "serverB-1", "response", "outcome"}).set("failed");
        failed.get(new String[]{"server-groups", "groupB", "serverB-1", "response", "result"}).set(new ModelNode());
        failed.get(new String[]{"server-groups", "groupB", "serverB-1", "response", "rolled-back"}).set(true);
        failed.get(new String[]{"server-groups", "groupB", "serverB-2", "host"}).set("host2");
        failed.get(new String[]{"server-groups", "groupB", "serverB-2", "response", "outcome"}).set("failed");
        failed.get(new String[]{"server-groups", "groupB", "serverB-2", "response", "result"}).set(new ModelNode());
        failed.get(new String[]{"server-groups", "groupB", "serverB-2", "response", "rolled-back"}).set(true);
        failed.get(new String[]{"server-groups", "groupB", "serverB-3", "host"}).set("host3");
        failed.get(new String[]{"server-groups", "groupB", "serverB-3", "response", "outcome"}).set("failed");
        failed.get(new String[]{"server-groups", "groupB", "serverB-3", "response", "failure-description"}).set("[DOM-4556] Something didn't work right");
        failed.get(new String[]{"server-groups", "groupB", "serverB-3", "response", "rolled-back"}).set(true);
        failed.get("compensating-op").set(op);
        ModelNode domainFail = new ModelNode();
        domainFail.get("outcome").set("failed");
        domainFail.get("domain-failure-description").set("[DOM-3333] Failed to apply to the domain model");
        ModelNode hostFail = new ModelNode();
        hostFail.get("outcome").set("failed");
        hostFail.get(new String[]{"host-failure-descriptions", "hostA"}).set("[DOM-3333] Failed to apply to the domain model");
        hostFail.get(new String[]{"host-failure-descriptions", "hostB"}).set("[DOM-3333] Failed to apply to the domain model");
        return Arrays.asList(success, partial, failed, domainFail, hostFail);
    }

    public static void main(String[] args) {
        List<ModelNode> results = Examples.getMultiServerResults();
        for (ModelNode result : results) {
            System.out.println(result);
            System.out.println();
        }
    }
}

