/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions.common;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.dmr.ModelNode;

public class ManagementDescription {
    private static final String RESOURCE_NAME = ManagementDescription.class.getPackage().getName() + ".LocalDescriptions";

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    public static ModelNode getManagementDescriptionWithInterfaces(Locale locale) {
        return ManagementDescription.getManagementDescription(locale, true);
    }

    public static ModelNode getManagementDescription(Locale locale, boolean interfaces) {
        ResourceBundle bundle2 = ManagementDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("core.management"));
        root.get("operations").setEmptyObject();
        root.get(new String[]{"children", "security-realm", "description"}).set(bundle2.getString("core.management.security-realms"));
        root.get(new String[]{"children", "security-realm", "min-occurs"}).set(0);
        root.get(new String[]{"children", "security-realm", "model-description"});
        root.get(new String[]{"children", "outbound-connection", "description"}).set(bundle2.getString("core.management.outbound-connections"));
        root.get(new String[]{"children", "outbound-connection", "min-occurs"}).set(0);
        root.get(new String[]{"children", "outbound-connection", "model-description"});
        if (interfaces) {
            root.get(new String[]{"children", "management-interface", "description"}).set(bundle2.getString("core.management.management-interfaces"));
            root.get(new String[]{"children", "management-interface", "min-occurs"}).set(0);
            root.get(new String[]{"children", "management-interface", "model-description"});
        }
        return root;
    }

    public static ModelNode getManagementSecurityRealmDescription(Locale locale) {
        ResourceBundle bundle2 = ManagementDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("core.management.security-realm"));
        root.get("operations").setEmptyObject();
        return root;
    }

    public static ModelNode getAddManagementSecurityRealmDescription(Locale locale) {
        ResourceBundle bundle2 = ManagementDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("add");
        root.get("description").set(bundle2.getString("core.management.security-realm.add"));
        System.out.println("====> " + root);
        return root;
    }

    public static ModelNode getManagementOutboundConnectionDescription(Locale locale) {
        ResourceBundle bundle2 = ManagementDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("core.management.outbound-connection"));
        root.get("operations").setEmptyObject();
        return root;
    }

    public static ModelNode getAddManagementOutboundConnectionDescription(Locale locale) {
        ResourceBundle bundle2 = ManagementDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("core.management.outbound-connection"));
        root.get("operation-name").set("add");
        root.get("description").set(bundle2.getString("core.management.outbound-connection.add"));
        return root;
    }

    public static ModelNode getNativeRemotingManagementDescription(Locale locale) {
        ResourceBundle bundle2 = ManagementDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("core.management.native-remoting-interface"));
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(false);
        return root;
    }

    public static ModelNode getAddNativeRemotingManagementDescription(Locale locale) {
        ResourceBundle bundle2 = ManagementDescription.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("description").set(bundle2.getString("core.management.native-remoting-interface.add"));
        op.get("operation-name").set("add");
        return op;
    }
}

