/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.interfaces;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jboss.as.controller.interfaces.AnyInterfaceCriteria;
import org.jboss.as.controller.interfaces.InetAddressMatchInterfaceCriteria;
import org.jboss.as.controller.interfaces.InterfaceCriteria;
import org.jboss.as.controller.interfaces.LinkLocalInterfaceCriteria;
import org.jboss.as.controller.interfaces.LoopbackAddressInterfaceCriteria;
import org.jboss.as.controller.interfaces.LoopbackInterfaceCriteria;
import org.jboss.as.controller.interfaces.NicInterfaceCriteria;
import org.jboss.as.controller.interfaces.NicMatchInterfaceCriteria;
import org.jboss.as.controller.interfaces.NotInterfaceCriteria;
import org.jboss.as.controller.interfaces.PointToPointInterfaceCriteria;
import org.jboss.as.controller.interfaces.PublicAddressInterfaceCriteria;
import org.jboss.as.controller.interfaces.SiteLocalInterfaceCriteria;
import org.jboss.as.controller.interfaces.SubnetMatchInterfaceCriteria;
import org.jboss.as.controller.interfaces.SupportsMulticastInterfaceCriteria;
import org.jboss.as.controller.interfaces.UpInterfaceCriteria;
import org.jboss.as.controller.interfaces.VirtualInterfaceCriteria;
import org.jboss.as.controller.interfaces.WildcardInetAddressInterfaceCriteria;
import org.jboss.as.controller.parsing.Element;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;

public final class ParsedInterfaceCriteria {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server");
    private static final ParsedInterfaceCriteria EMPTY = new ParsedInterfaceCriteria();
    private static final ParsedInterfaceCriteria ANY = new ParsedInterfaceCriteria(false, false, true);
    private static final ParsedInterfaceCriteria V4 = new ParsedInterfaceCriteria(true, false, false);
    private static final ParsedInterfaceCriteria V6 = new ParsedInterfaceCriteria(false, true, false);
    private final String failureMessage;
    private final boolean anyLocalV4;
    private final boolean anyLocalV6;
    private final boolean anyLocal;
    private final Set<InterfaceCriteria> criteria = new HashSet<InterfaceCriteria>();

    private ParsedInterfaceCriteria() {
        this.failureMessage = null;
        this.anyLocalV6 = false;
        this.anyLocalV4 = false;
        this.anyLocal = false;
    }

    private ParsedInterfaceCriteria(String failureMessage) {
        this.failureMessage = failureMessage;
        this.anyLocalV6 = false;
        this.anyLocalV4 = false;
        this.anyLocal = false;
    }

    private ParsedInterfaceCriteria(boolean anyLocalV4, boolean anyLocalV6, boolean anyLocal) {
        this.failureMessage = null;
        this.anyLocal = anyLocal;
        this.anyLocalV4 = anyLocalV4;
        this.anyLocalV6 = anyLocalV6;
    }

    private ParsedInterfaceCriteria(Set<InterfaceCriteria> criteria) {
        this.failureMessage = null;
        this.anyLocalV6 = false;
        this.anyLocalV4 = false;
        this.anyLocal = false;
        this.criteria.addAll(criteria);
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public boolean isAnyLocalV4() {
        return this.anyLocalV4;
    }

    public boolean isAnyLocalV6() {
        return this.anyLocalV6;
    }

    public boolean isAnyLocal() {
        return this.anyLocal;
    }

    public Set<InterfaceCriteria> getCriteria() {
        return this.criteria;
    }

    public static ParsedInterfaceCriteria parse(ModelNode criteria) {
        return ParsedInterfaceCriteria.parse(criteria, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ParsedInterfaceCriteria parse(ModelNode criteria, boolean specified) {
        ParsedInterfaceCriteria parsed = EMPTY;
        if (criteria.isDefined()) {
            if (criteria.getType() == ModelType.STRING) {
                String crit = criteria.asString();
                if ("any-address".equals(crit)) {
                    parsed = ANY;
                } else if ("any-ipv4-address".equals(crit)) {
                    parsed = V4;
                } else {
                    if (!"any-ipv6-address".equals(crit)) return new ParsedInterfaceCriteria(String.format("Illegal interface criteria %s; must be %s, %s or %s or a list of criteria elements", crit, "any-address", "any-ipv4-address", "any-ipv6-address"));
                    parsed = V6;
                }
            } else {
                if (criteria.getType() != ModelType.LIST) return new ParsedInterfaceCriteria(String.format("Illegal interface criteria type %s; must be %s or %s", criteria.getType(), ModelType.STRING, ModelType.LIST));
                try {
                    HashSet<InterfaceCriteria> criteriaSet = new HashSet<InterfaceCriteria>();
                    List nodes = criteria.asList();
                    Iterator i$ = nodes.iterator();
                    while (i$.hasNext()) {
                        ModelNode node = (ModelNode)i$.next();
                        InterfaceCriteria criterion = null;
                        if (node.getType() == ModelType.STRING) {
                            criterion = ParsedInterfaceCriteria.parseStringCriteria(node);
                        } else {
                            if (node.getType() != ModelType.PROPERTY) return new ParsedInterfaceCriteria(String.format("Illegal interface criteria list element type %s; must be %s or %s", node.getType(), ModelType.STRING, ModelType.PROPERTY));
                            criterion = ParsedInterfaceCriteria.parsePropertyCriteria(node);
                        }
                        if (criterion instanceof WildcardInetAddressInterfaceCriteria) {
                            if (nodes.size() > 1) {
                                log.warn((Object)"Wildcard address detected - will ignore other interface criteria.");
                            }
                            WildcardInetAddressInterfaceCriteria wc = (WildcardInetAddressInterfaceCriteria)criterion;
                            switch (wc.getVersion()) {
                                case V4: {
                                    return V4;
                                }
                                case V6: {
                                    return V6;
                                }
                            }
                            return ANY;
                        }
                        criteriaSet.add(criterion);
                    }
                    return new ParsedInterfaceCriteria(criteriaSet);
                }
                catch (ParsingException p) {
                    return new ParsedInterfaceCriteria(p.msg);
                }
            }
        }
        if (!specified) return parsed;
        if (parsed.getFailureMessage() != null) return parsed;
        if (parsed.isAnyLocal()) return parsed;
        if (parsed.isAnyLocalV4()) return parsed;
        if (parsed.isAnyLocalV6()) return parsed;
        if (parsed.getCriteria().size() != 0) return parsed;
        return new ParsedInterfaceCriteria("No interface criteria was provided");
    }

    private static InterfaceCriteria parseStringCriteria(ModelNode node) {
        Element element = Element.forName(node.asString());
        switch (element) {
            case LINK_LOCAL_ADDRESS: {
                return LinkLocalInterfaceCriteria.INSTANCE;
            }
            case LOOPBACK: {
                return LoopbackInterfaceCriteria.INSTANCE;
            }
            case MULTICAST: {
                return SupportsMulticastInterfaceCriteria.INSTANCE;
            }
            case POINT_TO_POINT: {
                return PointToPointInterfaceCriteria.INSTANCE;
            }
            case PUBLIC_ADDRESS: {
                return PublicAddressInterfaceCriteria.INSTANCE;
            }
            case SITE_LOCAL_ADDRESS: {
                return SiteLocalInterfaceCriteria.INSTANCE;
            }
            case UP: {
                return UpInterfaceCriteria.INSTANCE;
            }
            case VIRTUAL: {
                return VirtualInterfaceCriteria.INSTANCE;
            }
        }
        throw new ParsingException("Unknown simple interface criteria type " + node.asString());
    }

    private static InterfaceCriteria parsePropertyCriteria(ModelNode node) {
        Property prop = node.asProperty();
        String propName = prop.getName();
        Element element = Element.forName(propName);
        switch (element) {
            case ANY: {
                return ParsedInterfaceCriteria.parseCompoundCriteria(prop.getValue(), true);
            }
            case NOT: {
                return ParsedInterfaceCriteria.parseCompoundCriteria(prop.getValue(), true);
            }
            case INET_ADDRESS: {
                ParsedInterfaceCriteria.checkStringType(prop.getValue(), element.getLocalName(), true);
                try {
                    String rawAddress = prop.getValue().resolve().asString();
                    InetAddress address = InetAddress.getByName(rawAddress);
                    if (address.isAnyLocalAddress()) {
                        return new WildcardInetAddressInterfaceCriteria(address);
                    }
                    return new InetAddressMatchInterfaceCriteria(prop.getValue());
                }
                catch (UnknownHostException e) {
                    throw new ParsingException(String.format("Invalid address %s (%s)", prop.getValue().asString(), e.getLocalizedMessage()));
                }
            }
            case LOOPBACK_ADDRESS: {
                ParsedInterfaceCriteria.checkStringType(prop.getValue(), element.getLocalName(), true);
                return new LoopbackAddressInterfaceCriteria(prop.getValue());
            }
            case NIC: {
                ParsedInterfaceCriteria.checkStringType(prop.getValue(), element.getLocalName());
                return new NicInterfaceCriteria(prop.getValue().asString());
            }
            case NIC_MATCH: {
                ParsedInterfaceCriteria.checkStringType(prop.getValue(), element.getLocalName());
                try {
                    Pattern pattern = Pattern.compile(prop.getValue().asString());
                    return new NicMatchInterfaceCriteria(pattern);
                }
                catch (PatternSyntaxException e) {
                    throw new ParsingException(String.format("Invalid pattern %s for interface criteria %s", prop.getValue().asString(), element.getLocalName()));
                }
            }
            case SUBNET_MATCH: {
                String[] split = null;
                try {
                    String value = prop.getValue().asString();
                    split = value.split("/");
                    if (split.length != 2) {
                        throw new ParsingException(String.format("Invalid 'value' %s -- must be of the form address/mask", value));
                    }
                    InetAddress addr = InetAddress.getByName(split[0]);
                    byte[] net = addr.getAddress();
                    int mask = Integer.parseInt(split[1]);
                    return new SubnetMatchInterfaceCriteria(net, mask);
                }
                catch (ParsingException e) {
                    throw e;
                }
                catch (NumberFormatException e) {
                    throw new ParsingException(String.format("Invalid mask %s (%s)", split[0], e.getLocalizedMessage()));
                }
                catch (UnknownHostException e) {
                    throw new ParsingException(String.format("Invalid address %s (%s)", split[1], e.getLocalizedMessage()));
                }
            }
        }
        throw new ParsingException("Unknown complex interface criteria type " + node.asString());
    }

    private static InterfaceCriteria parseCompoundCriteria(ModelNode value, boolean any) {
        if (value.getType() == ModelType.LIST) {
            HashSet<InterfaceCriteria> nested = new HashSet<InterfaceCriteria>();
            for (ModelNode element : value.asList()) {
                if (element.getType() == ModelType.STRING) {
                    nested.add(ParsedInterfaceCriteria.parseStringCriteria(element));
                    continue;
                }
                if (element.getType() == ModelType.PROPERTY) {
                    nested.add(ParsedInterfaceCriteria.parsePropertyCriteria(element));
                    continue;
                }
                throw new ParsingException(String.format("Illegal interface criteria list element type %s; must be %s or %s", value.getType(), ModelType.STRING, ModelType.PROPERTY));
            }
            return any ? new AnyInterfaceCriteria(nested) : new NotInterfaceCriteria(nested);
        }
        throw new ParsingException(String.format("Illegal child type %s for criteria type %s; must be %s", value.getType(), any ? ANY : "not", ModelType.LIST));
    }

    private static void checkStringType(ModelNode node, String id) {
        ParsedInterfaceCriteria.checkStringType(node, id, false);
    }

    private static void checkStringType(ModelNode node, String id, boolean allowExpressions) {
        if (!(node.getType() == ModelType.STRING || allowExpressions && node.getType() == ModelType.EXPRESSION)) {
            throw new ParsingException(String.format("Illegal value %s for interface criteria %; must be %s", node.getType(), id, ModelType.STRING));
        }
    }

    private static class ParsingException
    extends RuntimeException {
        private static final long serialVersionUID = -5627251228393035383L;
        private final String msg;

        private ParsingException(String msg) {
            this.msg = msg;
        }
    }
}

