/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.ExtensionDescription;
import org.jboss.as.controller.operations.common.AbstractExtensionAddHandler;
import org.jboss.dmr.ModelNode;

public abstract class AbstractExtensionRemoveHandler
implements ModelRemoveOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "remove";

    public static ModelNode getRemoveExtensionOperation(ModelNode address) {
        ModelNode op = new ModelNode();
        op.get("operation").set(OPERATION_NAME);
        op.get("address").set(address);
        return op;
    }

    protected AbstractExtensionRemoveHandler() {
    }

    @Override
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress(operation.require("address"));
        String module = address.getLastElement().getValue();
        this.uninstallExtension(module, context);
        resultHandler.handleResultComplete();
        return new BasicOperationResult(AbstractExtensionAddHandler.getAddExtensionOperation(operation.get("address")));
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return ExtensionDescription.getExtensionRemoveOperation(locale);
    }

    protected abstract void uninstallExtension(String var1, OperationContext var2) throws OperationFailedException;
}

