/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import org.jboss.as.controller.ControllerResource;
import org.jboss.as.controller.ControllerTransactionContext;
import org.jboss.as.controller.ControllerTransactionSynchronization;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class ControllerTransaction
implements ControllerTransactionContext {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.controller");
    private final Set<ControllerResource> resources = new LinkedHashSet<ControllerResource>();
    private final Set<ControllerTransactionSynchronization> synchronizations = new LinkedHashSet<ControllerTransactionSynchronization>();
    private volatile boolean rollbackOnly;
    private final ModelNode id;
    private final long creationTime = System.currentTimeMillis();

    public ControllerTransaction() {
        UUID uuid = UUID.randomUUID();
        this.id = new ModelNode();
        this.id.add(uuid.getMostSignificantBits());
        this.id.add(uuid.getLeastSignificantBits());
    }

    public ControllerTransaction(ModelNode id) {
        this.id = id;
    }

    public void commit() {
        for (ControllerTransactionSynchronization sync : this.synchronizations) {
            try {
                sync.beforeCompletion();
            }
            catch (Exception e) {
                log.errorf((Throwable)e, "Caught exception applying beforeCompletion notification for transaction %s on synchronization %s", (Object)this.id, (Object)sync);
            }
        }
        for (ControllerResource resource : this.resources) {
            try {
                if (this.rollbackOnly) {
                    resource.rollback();
                    continue;
                }
                resource.commit();
            }
            catch (Exception e) {
                if (this.rollbackOnly) {
                    log.errorf((Throwable)e, "Caught exception rolling back transaction %s on resource %s", (Object)this.id, (Object)resource);
                    continue;
                }
                log.errorf((Throwable)e, "Caught exception committing transaction %s on resource %s", (Object)this.id, (Object)resource);
            }
        }
        for (ControllerTransactionSynchronization sync : this.synchronizations) {
            try {
                sync.afterCompletion(!this.rollbackOnly);
            }
            catch (Exception e) {
                log.errorf((Throwable)e, "Caught exception applying beforeCompletion notification for transaction %s on synchronization %s", (Object)this.id, (Object)sync);
            }
        }
    }

    @Override
    public ModelNode getTransactionId() {
        return this.id;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    @Override
    public void registerResource(ControllerResource resource) {
        this.resources.add(resource);
    }

    @Override
    public void deregisterResource(ControllerResource resource) {
        this.resources.remove(resource);
    }

    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    @Override
    public void registerSynchronization(ControllerTransactionSynchronization synchronization) {
        this.synchronizations.add(synchronization);
    }
}

