/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.SocketBindingGroupDescription;
import org.jboss.as.controller.operations.common.SocketBindingGroupIncludeRemoveHandler;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;

public class SocketBindingGroupIncludeAddHandler
implements ModelUpdateOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add-include";
    public static final SocketBindingGroupIncludeAddHandler INSTANCE = new SocketBindingGroupIncludeAddHandler();
    private final ParameterValidator typeValidator = new StringLengthValidator(1);

    public static ModelNode getOperation(ModelNode address, String include) {
        ModelNode op = new ModelNode();
        op.get("operation").set(OPERATION_NAME);
        op.get("address").set(address);
        op.get("include").set(include);
        return op;
    }

    private SocketBindingGroupIncludeAddHandler() {
    }

    @Override
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        ModelNode param = operation.get("include");
        ModelNode includes = context.getSubModel().get("include");
        this.typeValidator.validateParameter("include", param);
        includes.add(param);
        resultHandler.handleResultComplete();
        ModelNode compensating = SocketBindingGroupIncludeRemoveHandler.getOperation(operation.get("address"), param.asString());
        return new BasicOperationResult(compensating);
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return SocketBindingGroupDescription.getAddSocketBindingGroupIncludeOperation(locale);
    }
}

