/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.client.Operation;
import org.jboss.dmr.ModelNode;

public class SynchronousOperationSupport<T> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static <T> ModelNode execute(Operation operation, T handback, AsynchronousOperationController<T> controller) {
        final AtomicInteger status = new AtomicInteger();
        final ModelNode finalResult = new ModelNode();
        finalResult.get("outcome");
        finalResult.get("result");
        ResultHandler resultHandler = new ResultHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleResultFragment(String[] location, ModelNode fragment) {
                ModelNode modelNode = finalResult;
                synchronized (modelNode) {
                    if (status.get() == 0) {
                        finalResult.get("result").get(location).set(fragment);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleResultComplete() {
                ModelNode modelNode = finalResult;
                synchronized (modelNode) {
                    status.compareAndSet(0, 1);
                    finalResult.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleFailed(ModelNode failureDescription) {
                ModelNode modelNode = finalResult;
                synchronized (modelNode) {
                    if (status.compareAndSet(0, 3) && failureDescription != null && failureDescription.isDefined()) {
                        finalResult.get("failure-description").set(failureDescription);
                    }
                    finalResult.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleCancellation() {
                ModelNode modelNode = finalResult;
                synchronized (modelNode) {
                    if (status.compareAndSet(0, 2)) {
                        finalResult.remove("result");
                    }
                    finalResult.notify();
                }
            }
        };
        OperationResult handlerResult = controller.execute(operation, resultHandler, handback);
        boolean intr = false;
        try {
            ModelNode modelNode = finalResult;
            // MONITORENTER : modelNode
            while (true) {
                int s = status.get();
                switch (s) {
                    case 1: {
                        finalResult.get("outcome").set("success");
                        if (handlerResult.getCompensatingOperation() != null) {
                            finalResult.get("compensating-operation").set(handlerResult.getCompensatingOperation());
                        }
                        ModelNode modelNode2 = finalResult;
                        // MONITOREXIT : modelNode
                        if (!intr) return modelNode2;
                        Thread.currentThread().interrupt();
                        return modelNode2;
                    }
                    case 2: {
                        finalResult.get("outcome").set("cancelled");
                        throw new CancellationException();
                    }
                    case 3: {
                        finalResult.get("outcome").set("failed");
                        if (!finalResult.hasDefined("result")) {
                            finalResult.remove("result");
                        }
                        ModelNode modelNode3 = finalResult;
                        // MONITOREXIT : modelNode
                        if (!intr) return modelNode3;
                        Thread.currentThread().interrupt();
                        return modelNode3;
                    }
                }
                try {
                    finalResult.wait();
                }
                catch (InterruptedException e) {
                    intr = true;
                    handlerResult.getCancellable().cancel();
                }
                continue;
                break;
            }
        }
        catch (Throwable throwable) {
            if (!intr) throw throwable;
            Thread.currentThread().interrupt();
            throw throwable;
        }
    }

    public static interface AsynchronousOperationController<T> {
        public OperationResult execute(Operation var1, ResultHandler var2, T var3);
    }
}

