/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.staxmapper.XMLElementWriter;

public final class ExtensionContextImpl
implements ExtensionContext {
    private final ModelNodeRegistration profileRegistration;
    private final ModelNodeRegistration deploymentOverrideRegistration;
    private final SubsystemXmlWriterRegistry writerRegistry;

    public ExtensionContextImpl(ModelNodeRegistration profileRegistration, ModelNodeRegistration deploymentOverrideRegistration, SubsystemXmlWriterRegistry writerRegistry) {
        if (profileRegistration == null) {
            throw new IllegalArgumentException("profileRegistration is null");
        }
        if (writerRegistry == null) {
            throw new IllegalArgumentException("writerRegistry is null");
        }
        this.profileRegistration = profileRegistration;
        this.deploymentOverrideRegistration = deploymentOverrideRegistration;
        this.writerRegistry = writerRegistry;
    }

    @Override
    public SubsystemRegistration registerSubsystem(final String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return new SubsystemRegistration(){

            @Override
            public ModelNodeRegistration registerSubsystemModel(DescriptionProvider descriptionProvider) {
                if (descriptionProvider == null) {
                    throw new IllegalArgumentException("descriptionProvider is null");
                }
                return ExtensionContextImpl.this.profileRegistration.registerSubModel(new PathElement("subsystem", name), descriptionProvider);
            }

            @Override
            public ModelNodeRegistration registerDeploymentModel(DescriptionProvider descriptionProvider) {
                if (descriptionProvider == null) {
                    throw new IllegalArgumentException("descriptionProvider is null");
                }
                return ExtensionContextImpl.this.deploymentOverrideRegistration.registerSubModel(new PathElement("configuration", name), descriptionProvider);
            }

            @Override
            public void registerXMLElementWriter(XMLElementWriter<SubsystemMarshallingContext> writer) {
                ExtensionContextImpl.this.writerRegistry.registerSubsystemWriter(name, writer);
            }
        };
    }
}

