/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers.standalone.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.client.Cancellable;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationResult;
import org.jboss.as.controller.client.ResultHandler;
import org.jboss.as.controller.client.helpers.standalone.impl.AbstractServerDeploymentManager;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;

public class ModelControllerClientServerDeploymentManager
extends AbstractServerDeploymentManager {
    private final ModelControllerClient client;

    public ModelControllerClientServerDeploymentManager(ModelControllerClient client) {
        this.client = client;
    }

    @Override
    protected Future<ModelNode> executeOperation(Operation operation) {
        Handler handler = new Handler(operation);
        OperationResult c = this.client.execute(operation, handler.resultHandler);
        handler.setCancellable(c.getCancellable());
        return handler;
    }

    private static class Handler
    implements Future<ModelNode> {
        private final Operation operation;
        private AtomicReference<State> state = new AtomicReference<State>(State.RUNNING);
        private final Thread runner = Thread.currentThread();
        private final ModelNode result = new ModelNode();
        private Cancellable cancellable;
        private final AtomicReference<Exception> exception = new AtomicReference();
        private final ResultHandler resultHandler = new ResultHandler(){

            @Override
            public void handleResultFragment(String[] location, ModelNode fragment) {
                if (Handler.this.state.get() == State.RUNNING) {
                    Handler.this.result.get(location).set(fragment);
                }
            }

            @Override
            public void handleResultComplete() {
                Handler.this.state.compareAndSet(State.RUNNING, State.DONE);
                Handler.this.cleanUpAndNotify();
            }

            @Override
            public void handleCancellation() {
                Handler.this.state.compareAndSet(State.RUNNING, State.CANCELLED);
                Handler.this.cleanUpAndNotify();
            }

            @Override
            public void handleFailed(ModelNode failureDescription) {
                String message = failureDescription.isDefined() ? failureDescription.toString() : "Operation failed with no failure description";
                Exception e = new Exception(message);
                Handler.this.exception.compareAndSet(null, e);
                Handler.this.state.compareAndSet(State.RUNNING, State.DONE);
                Handler.this.cleanUpAndNotify();
            }
        };

        private Handler(Operation operation) {
            this.operation = operation;
        }

        synchronized void cleanUpAndNotify() {
            for (InputStream in : this.operation.getInputStreams()) {
                StreamUtils.safeClose((Closeable)in);
            }
            this.notifyAll();
        }

        void setCancellable(Cancellable c) {
            this.cancellable = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = false;
            if (this.state.get() == State.RUNNING) {
                try {
                    if (this.cancellable.cancel()) {
                        cancelled = this.state.compareAndSet(State.RUNNING, State.CANCELLED);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!cancelled) {
                    if (mayInterruptIfRunning) {
                        this.runner.interrupt();
                    }
                    if (this.state.compareAndSet(State.RUNNING, State.DONE)) {
                        this.exception.set(new CancellationException());
                    }
                }
            }
            Handler handler = this;
            synchronized (handler) {
                this.notifyAll();
            }
            return cancelled;
        }

        @Override
        public boolean isCancelled() {
            return this.state.get() == State.CANCELLED;
        }

        @Override
        public boolean isDone() {
            return this.state.get() != State.RUNNING;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ModelNode get() throws InterruptedException, ExecutionException {
            Handler handler = this;
            synchronized (handler) {
                while (!this.isDone()) {
                    this.wait();
                }
                return this.getResult();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ModelNode get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long toWait = unit.toMillis(timeout);
            long expire = System.currentTimeMillis() + toWait;
            Handler handler = this;
            synchronized (handler) {
                while (!this.isDone()) {
                    this.wait(toWait);
                    if (this.isDone()) continue;
                    long now = System.currentTimeMillis();
                    if (now >= expire) {
                        throw new TimeoutException();
                    }
                    toWait = expire - now;
                }
                return this.getResult();
            }
        }

        private ModelNode getResult() throws ExecutionException {
            Exception e = this.exception.get();
            if (e instanceof ExecutionException) {
                throw (ExecutionException)e;
            }
            if (e instanceof CancellationException) {
                throw (CancellationException)e;
            }
            if (e != null) {
                throw new ExecutionException(e);
            }
            if (this.state.get() == State.CANCELLED) {
                throw new CancellationException();
            }
            return this.result;
        }

        private static enum State {
            RUNNING,
            CANCELLED,
            DONE;

        }
    }
}

