/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.List;
import java.util.Locale;
import org.jboss.as.connector.subsystems.resourceadapters.ConnectionDefinitionService;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableConnDef;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableResourceAdapter;
import org.jboss.as.connector.subsystems.resourceadapters.RaOperationUtil;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersSubsystemProviders;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class ConnectionDefinitionAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final ConnectionDefinitionAdd INSTANCE = new ConnectionDefinitionAdd();

    public ModelNode getModelDescription(Locale locale) {
        return ResourceAdaptersSubsystemProviders.ADD_CONNECTION_DEFINITION_DESC.getModelDescription(Locale.getDefault());
    }

    protected void populateModel(ModelNode operation, ModelNode modelNode) throws OperationFailedException {
        for (SimpleAttributeDefinition attribute : ResourceAdaptersSubsystemProviders.CONNECTIONDEFINITIONS_NODEATTRIBUTE) {
            if (!attribute.isAllowed(operation) && operation.hasDefined(attribute.getName())) {
                throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.invalid(attribute.getName())));
            }
            attribute.validateAndSet(operation, modelNode);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode recoveryEnvModel, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> serviceControllers) throws OperationFailedException {
        ModelNode address = operation.require("address");
        PathAddress path = PathAddress.pathAddress((ModelNode)address);
        String archiveName = path.getElement(path.size() - 2).getValue();
        String poolName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        try {
            ServiceName serviceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{archiveName, poolName});
            ServiceName raServiceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{archiveName});
            ModifiableResourceAdapter ravalue = (ModifiableResourceAdapter)((Object)context.getServiceRegistry(false).getService(raServiceName).getValue());
            boolean isXa = ravalue.getTransactionSupport() == TransactionSupportEnum.XATransaction;
            ModifiableConnDef connectionDefinitionValue = RaOperationUtil.buildConnectionDefinitionObject(context, operation, poolName, isXa);
            ServiceTarget serviceTarget = context.getServiceTarget();
            ConnectionDefinitionService service = new ConnectionDefinitionService(connectionDefinitionValue);
            ServiceController controller = serviceTarget.addService(serviceName, (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(raServiceName, ModifiableResourceAdapter.class, service.getRaInjector()).addListener((ServiceListener)verificationHandler).install();
            serviceControllers.add(controller);
        }
        catch (ValidateException e) {
            throw new OperationFailedException((Throwable)e, operation);
        }
    }
}

