/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.List;
import java.util.Locale;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemProviders;
import org.jboss.as.connector.subsystems.datasources.XADataSourceConfigService;
import org.jboss.as.connector.subsystems.datasources.XaDataSourcePropertiesService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class XaDataSourcePropertyAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final XaDataSourcePropertyAdd INSTANCE = new XaDataSourcePropertyAdd();

    public ModelNode getModelDescription(Locale locale) {
        return DataSourcesSubsystemProviders.ADD_XADATASOURCE_PROPERTIES_DESC.getModelDescription(Locale.getDefault());
    }

    protected void populateModel(ModelNode operation, ModelNode modelNode) throws OperationFailedException {
        Constants.XADATASOURCE_PROPERTY_VALUE.validateAndSet(operation, modelNode);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode recoveryEnvModel, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> serviceControllers) throws OperationFailedException {
        ServiceName dataSourceConfigServiceName;
        String configPropertyValue = Constants.XADATASOURCE_PROPERTY_VALUE.resolveModelAttribute(context, recoveryEnvModel).asString();
        ModelNode address = operation.require("address");
        PathAddress path = PathAddress.pathAddress((ModelNode)address);
        String dsName = path.getElement(path.size() - 2).getValue();
        String configPropertyName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        ServiceName serviceName = XADataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{dsName}).append(new String[]{"xa-datasource-properties"}).append(new String[]{configPropertyName});
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController dataSourceConfigController = registry.getService(dataSourceConfigServiceName = XADataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{dsName}));
        if (dataSourceConfigController == null || !((XaDataSource)dataSourceConfigController.getValue()).isEnabled().booleanValue()) {
            ServiceTarget serviceTarget = context.getServiceTarget();
            XaDataSourcePropertiesService service = new XaDataSourcePropertiesService(configPropertyName, configPropertyValue);
            ServiceController controller = serviceTarget.addService(serviceName, (Service)service).setInitialMode(ServiceController.Mode.NEVER).addListener((ServiceListener)verificationHandler).install();
            if (serviceControllers != null) {
                serviceControllers.add(controller);
            }
            context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
        } else {
            context.reloadRequired();
        }
    }
}

