/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.ra.processors;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.connector.dynamicresource.descriptionproviders.StatisticsDescriptionProvider;
import org.jboss.as.connector.dynamicresource.descriptionproviders.StatisticsElementDescriptionProvider;
import org.jboss.as.connector.dynamicresource.descriptionproviders.SubSystemExtensionDescriptionProvider;
import org.jboss.as.connector.dynamicresource.operations.ClearStatisticsHandler;
import org.jboss.as.connector.subsystems.common.pool.PoolMetrics;
import org.jboss.as.connector.subsystems.resourceadapters.IronJacamarResource;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersSubsystemProviders;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.api.connectionmanager.pool.PoolStatistics;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.spi.statistics.StatisticsPlugin;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;

public abstract class AbstractResourceAdapterDeploymentServiceListener
extends AbstractServiceListener<Object> {
    private final ManagementResourceRegistration registration;
    private final String deploymentUnitName;
    private final Resource deploymentResource;

    public AbstractResourceAdapterDeploymentServiceListener(ManagementResourceRegistration registration, String deploymentUnitName, Resource deploymentResource) {
        this.registration = registration;
        this.deploymentUnitName = deploymentUnitName;
        this.deploymentResource = deploymentResource;
    }

    public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
        switch (transition) {
            case STARTING_to_UP: {
                CommonDeployment deploymentMD = this.getDeploymentMetadata(controller);
                if (deploymentMD.getConnectionManagers() == null) break;
                for (ConnectionManager cm : deploymentMD.getConnectionManagers()) {
                    PoolStatistics poolStats;
                    if (cm.getPool() == null || (poolStats = cm.getPool().getStatistics()).getNames().size() == 0) continue;
                    StatisticsDescriptionProvider statsResourceDescriptionProvider = new StatisticsDescriptionProvider(ResourceAdaptersSubsystemProviders.RESOURCE_NAME, "statistics", new StatisticsPlugin[]{poolStats});
                    PathElement pe = PathElement.pathElement((String)"subsystem", (String)"resource-adapters");
                    PathElement peStats = PathElement.pathElement((String)"statistics", (String)"statistics");
                    PathElement peCD = PathElement.pathElement((String)"connection-definitions", (String)cm.getJndiName());
                    ManagementResourceRegistration overrideRegistration = this.registration;
                    overrideRegistration = this.registration.isAllowsOverride() && this.registration.getOverrideModel(this.deploymentUnitName) == null ? this.registration.registerOverrideModel(this.deploymentUnitName, new OverrideDescriptionProvider(){

                        public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
                            return Collections.emptyMap();
                        }

                        public Map<String, ModelNode> getChildTypeOverrideDescriptions(Locale locale) {
                            return Collections.emptyMap();
                        }
                    }) : this.registration.getOverrideModel(this.deploymentUnitName);
                    ManagementResourceRegistration subRegistration = overrideRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{pe}));
                    if (subRegistration == null) {
                        subRegistration = overrideRegistration.registerSubModel(pe, (DescriptionProvider)new SubSystemExtensionDescriptionProvider(ResourceAdaptersSubsystemProviders.RESOURCE_NAME, "deployment-subsystem"));
                    }
                    IronJacamarResource.IronJacamarRuntimeResource subsystemResource = new IronJacamarResource.IronJacamarRuntimeResource();
                    this.deploymentResource.registerChild(pe, (Resource)subsystemResource);
                    ManagementResourceRegistration statsRegistration = subRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{peStats}));
                    if (statsRegistration == null) {
                        statsRegistration = subRegistration.registerSubModel(peStats, (DescriptionProvider)new StatisticsElementDescriptionProvider(ResourceAdaptersSubsystemProviders.RESOURCE_NAME, "statistics"));
                    }
                    IronJacamarResource.IronJacamarRuntimeResource statisticsResource = new IronJacamarResource.IronJacamarRuntimeResource();
                    subsystemResource.registerChild(peStats, (Resource)statisticsResource);
                    if (statsRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{peCD})) == null) {
                        ManagementResourceRegistration cdSubRegistration = statsRegistration.registerSubModel(peCD, (DescriptionProvider)statsResourceDescriptionProvider);
                        IronJacamarResource.IronJacamarRuntimeResource cdResource = new IronJacamarResource.IronJacamarRuntimeResource();
                        statisticsResource.registerChild(peCD, (Resource)cdResource);
                        for (String statName : poolStats.getNames()) {
                            cdSubRegistration.registerMetric(statName, (OperationStepHandler)new PoolMetrics.ParametrizedPoolMetricsHandler((StatisticsPlugin)poolStats));
                        }
                        cdSubRegistration.registerOperationHandler("clear-statistics", (OperationStepHandler)new ClearStatisticsHandler(new StatisticsPlugin[]{poolStats}), ResourceAdaptersSubsystemProviders.CLEAR_STATISTICS_DESC, false);
                    }
                    this.registerIronjacamar(controller, subRegistration, (Resource)subsystemResource);
                }
                break;
            }
            case UP_to_STOP_REQUESTED: {
                ManagementResourceRegistration subsystemReg;
                PathElement pe = PathElement.pathElement((String)"subsystem", (String)"resource-adapters");
                PathElement ijPe = PathElement.pathElement((String)"ironjacamar", (String)"ironjacamar");
                PathElement peStats = PathElement.pathElement((String)"statistics", (String)"statistics");
                PathElement peCD = PathElement.pathElement((String)"connection-definitions");
                ManagementResourceRegistration overrideRegistration = this.registration;
                if (this.registration.isAllowsOverride() && this.registration.getOverrideModel(this.deploymentUnitName) != null) {
                    overrideRegistration = this.registration.getOverrideModel(this.deploymentUnitName);
                }
                if ((subsystemReg = overrideRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{pe}))) != null) {
                    ManagementResourceRegistration statsReg;
                    if (subsystemReg.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{ijPe})) != null) {
                        subsystemReg.unregisterSubModel(ijPe);
                    }
                    if ((statsReg = subsystemReg.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{peStats}))) != null) {
                        if (statsReg.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{peCD})) != null) {
                            statsReg.unregisterSubModel(peCD);
                        }
                        subsystemReg.unregisterSubModel(peStats);
                    }
                    overrideRegistration.unregisterSubModel(pe);
                }
                this.deploymentResource.removeChild(pe);
            }
        }
    }

    protected abstract void registerIronjacamar(ServiceController<? extends Object> var1, ManagementResourceRegistration var2, Resource var3);

    protected abstract CommonDeployment getDeploymentMetadata(ServiceController<? extends Object> var1);
}

