/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.workmanager;

import java.util.concurrent.Executor;
import org.jboss.as.connector.ConnectorLogger;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.jca.core.security.UsersRoles;
import org.jboss.jca.core.spi.security.Callback;
import org.jboss.jca.core.spi.transaction.xa.XATerminator;
import org.jboss.jca.core.tx.jbossts.XATerminatorImpl;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.BlockingExecutor;
import org.jboss.tm.JBossXATerminator;

public final class WorkManagerService
implements Service<WorkManager> {
    private final WorkManager value;
    private final InjectedValue<Executor> executorShort = new InjectedValue();
    private final InjectedValue<Executor> executorLong = new InjectedValue();
    private final InjectedValue<JBossXATerminator> xaTerminator = new InjectedValue();
    private volatile Callback callback;

    public WorkManagerService(WorkManager value) {
        ConnectorLogger.ROOT_LOGGER.debugf("Building WorkManager", new Object[0]);
        this.value = value;
    }

    public WorkManager getValue() throws IllegalStateException {
        return ConnectorServices.notNull(this.value);
    }

    public void start(StartContext context) throws StartException {
        BlockingExecutor longRunning = (BlockingExecutor)this.executorLong.getOptionalValue();
        if (longRunning != null) {
            this.value.setLongRunningThreadPool(longRunning);
            this.value.setShortRunningThreadPool((BlockingExecutor)this.executorShort.getValue());
        } else {
            this.value.setLongRunningThreadPool((BlockingExecutor)this.executorShort.getValue());
            this.value.setShortRunningThreadPool((BlockingExecutor)this.executorShort.getValue());
        }
        this.value.setXATerminator((XATerminator)new XATerminatorImpl((JBossXATerminator)this.xaTerminator.getValue()));
        String usersProperties = System.getProperty("users.properties");
        String rolesProperties = System.getProperty("roles.properties");
        if (usersProperties != null && rolesProperties != null) {
            try {
                UsersRoles usersRoles = new UsersRoles();
                usersRoles.setUsersProperties(usersProperties);
                usersRoles.setRolesProperties(rolesProperties);
                usersRoles.start();
                this.callback = usersRoles;
                this.value.setCallbackSecurity(this.callback);
            }
            catch (Throwable t) {
                ConnectorLogger.ROOT_LOGGER.debug(t.getMessage(), t);
            }
        }
        ConnectorLogger.ROOT_LOGGER.debugf("Starting JCA WorkManager", new Object[0]);
    }

    public void stop(StopContext context) {
        this.value.shutdown();
        try {
            if (this.callback != null) {
                this.callback.stop();
            }
        }
        catch (Throwable t) {
            ConnectorLogger.ROOT_LOGGER.debug(t.getMessage(), t);
        }
    }

    public Injector<Executor> getExecutorShortInjector() {
        return this.executorShort;
    }

    public Injector<Executor> getExecutorLongInjector() {
        return this.executorLong;
    }

    public Injector<JBossXATerminator> getXaTerminatorInjector() {
        return this.xaTerminator;
    }
}

