/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableResourceAdapter;
import org.jboss.as.connector.subsystems.resourceadapters.RaOperationUtil;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdapterService;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersService;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersSubsystemProviders;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class RaAdd
implements OperationStepHandler {
    static final RaAdd INSTANCE = new RaAdd();

    protected void populateModel(ModelNode operation, ModelNode model) {
        for (String attribute : ResourceAdaptersSubsystemProviders.RESOURCEADAPTER_ATTRIBUTE) {
            if (!operation.get(attribute).isDefined()) continue;
            model.get(attribute).set(operation.get(attribute));
        }
    }

    public void execute(OperationContext context, ModelNode operation) {
        ModelNode subModel = context.readModelForUpdate(PathAddress.EMPTY_ADDRESS);
        this.populateModel(operation, subModel);
        ModelNode address = operation.require("address");
        final String archive = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        operation.get(Constants.ARCHIVE.getName()).set(archive);
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceTarget serviceTarget = context.getServiceTarget();
                    ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                    ModifiableResourceAdapter resourceAdapter = RaOperationUtil.buildResourceAdaptersObject(operation);
                    ServiceController resourceAdaptersService = context.getServiceRegistry(false).getService(ConnectorServices.RESOURCEADAPTERS_SERVICE);
                    ServiceController controller = null;
                    if (resourceAdaptersService == null) {
                        controller = serviceTarget.addService(ConnectorServices.RESOURCEADAPTERS_SERVICE, (Service)new ResourceAdaptersService()).setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler).install();
                    }
                    ServiceName raServiceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{archive});
                    ResourceAdapterService raService = new ResourceAdapterService(resourceAdapter);
                    serviceTarget.addService(raServiceName, (Service)raService).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(ConnectorServices.RESOURCEADAPTERS_SERVICE, ResourceAdaptersService.ModifiableResourceAdaptors.class, raService.getResourceAdaptersInjector()).addListener((ServiceListener)verificationHandler).install();
                    context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK && controller != null) {
                        context.removeService(ConnectorServices.RESOURCEADAPTERS_SERVICE);
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }
}

